rule win_bluelight_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bluelight."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bluelight"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff771c ff15???????? ff771c 8b7714 ff15???????? 5f 8bc6 }
            // n = 7, score = 100
            //   ff771c               | push                dword ptr [edi + 0x1c]
            //   ff15????????         |                     
            //   ff771c               | push                dword ptr [edi + 0x1c]
            //   8b7714               | mov                 esi, dword ptr [edi + 0x14]
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_1 = { 884dc7 8955d0 81faa7000000 0f87a8410000 ff249526044300 6b4b0428 6a04 }
            // n = 7, score = 100
            //   884dc7               | mov                 byte ptr [ebp - 0x39], cl
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   81faa7000000         | cmp                 edx, 0xa7
            //   0f87a8410000         | ja                  0x41ae
            //   ff249526044300       | jmp                 dword ptr [edx*4 + 0x430426]
            //   6b4b0428             | imul                ecx, dword ptr [ebx + 4], 0x28
            //   6a04                 | push                4

        $sequence_2 = { 85db 740f ff7760 53 ff7764 e8???????? 83c40c }
            // n = 7, score = 100
            //   85db                 | test                ebx, ebx
            //   740f                 | je                  0x11
            //   ff7760               | push                dword ptr [edi + 0x60]
            //   53                   | push                ebx
            //   ff7764               | push                dword ptr [edi + 0x64]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { eb0c 8b4508 8907 c7450800000000 8b4518 894710 8b4520 }
            // n = 7, score = 100
            //   eb0c                 | jmp                 0xe
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8907                 | mov                 dword ptr [edi], eax
            //   c7450800000000       | mov                 dword ptr [ebp + 8], 0
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   894710               | mov                 dword ptr [edi + 0x10], eax
            //   8b4520               | mov                 eax, dword ptr [ebp + 0x20]

        $sequence_4 = { f64605c0 7415 8d442420 68???????? 50 e8???????? ff44241c }
            // n = 7, score = 100
            //   f64605c0             | test                byte ptr [esi + 5], 0xc0
            //   7415                 | je                  0x17
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff44241c             | inc                 dword ptr [esp + 0x1c]

        $sequence_5 = { e8???????? 8d4d8c 894314 e8???????? 8d4d9c e8???????? 8d4d94 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4d8c               | lea                 ecx, [ebp - 0x74]
            //   894314               | mov                 dword ptr [ebx + 0x14], eax
            //   e8????????           |                     
            //   8d4d9c               | lea                 ecx, [ebp - 0x64]
            //   e8????????           |                     
            //   8d4d94               | lea                 ecx, [ebp - 0x6c]

        $sequence_6 = { e8???????? b8???????? e9???????? 8d8d60feffff e9???????? 8d4da8 e9???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b8????????           |                     
            //   e9????????           |                     
            //   8d8d60feffff         | lea                 ecx, [ebp - 0x1a0]
            //   e9????????           |                     
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   e9????????           |                     

        $sequence_7 = { ff761c 50 e8???????? 83c410 8d4510 50 ff750c }
            // n = 7, score = 100
            //   ff761c               | push                dword ptr [esi + 0x1c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d4510               | lea                 eax, [ebp + 0x10]
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_8 = { 8b45d4 3bde 7507 8bc8 e8???????? 8a4d9f 33db }
            // n = 7, score = 100
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   3bde                 | cmp                 ebx, esi
            //   7507                 | jne                 9
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   8a4d9f               | mov                 cl, byte ptr [ebp - 0x61]
            //   33db                 | xor                 ebx, ebx

        $sequence_9 = { ff7304 8b4d0c ff73ec 6a2d 5a e8???????? 8943ec }
            // n = 7, score = 100
            //   ff7304               | push                dword ptr [ebx + 4]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   ff73ec               | push                dword ptr [ebx - 0x14]
            //   6a2d                 | push                0x2d
            //   5a                   | pop                 edx
            //   e8????????           |                     
            //   8943ec               | mov                 dword ptr [ebx - 0x14], eax

    condition:
        7 of them and filesize < 2191360
}