rule win_bluenoroff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bluenoroff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bluenoroff"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 33ff 53 ff15???????? 8b450c }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   33ff                 | xor                 edi, edi
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_1 = { 8bf0 83c404 85f6 7429 8b4508 8b5510 }
            // n = 6, score = 300
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi
            //   7429                 | je                  0x2b
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]

        $sequence_2 = { 8bf8 85ff 7421 6a00 8d55fc 52 56 }
            // n = 7, score = 300
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7421                 | je                  0x23
            //   6a00                 | push                0
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   52                   | push                edx
            //   56                   | push                esi

        $sequence_3 = { b912010000 8bf3 f3a5 a1???????? 8b5004 83c410 8d7004 }
            // n = 7, score = 300
            //   b912010000           | mov                 ecx, 0x112
            //   8bf3                 | mov                 esi, ebx
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   a1????????           |                     
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   83c410               | add                 esp, 0x10
            //   8d7004               | lea                 esi, [eax + 4]

        $sequence_4 = { 83c41c 83f801 750e 8d8dfcfffeff }
            // n = 4, score = 300
            //   83c41c               | add                 esp, 0x1c
            //   83f801               | cmp                 eax, 1
            //   750e                 | jne                 0x10
            //   8d8dfcfffeff         | lea                 ecx, [ebp - 0x10004]

        $sequence_5 = { 83feff 7433 8d4e01 51 6a40 ff15???????? }
            // n = 6, score = 300
            //   83feff               | cmp                 esi, -1
            //   7433                 | je                  0x35
            //   8d4e01               | lea                 ecx, [esi + 1]
            //   51                   | push                ecx
            //   6a40                 | push                0x40
            //   ff15????????         |                     

        $sequence_6 = { 51 52 8d85fcfffeff 68ffff0000 }
            // n = 4, score = 300
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8d85fcfffeff         | lea                 eax, [ebp - 0x10004]
            //   68ffff0000           | push                0xffff

        $sequence_7 = { 83c41c 8d95ecfffeff 33c9 52 }
            // n = 4, score = 300
            //   83c41c               | add                 esp, 0x1c
            //   8d95ecfffeff         | lea                 edx, [ebp - 0x10014]
            //   33c9                 | xor                 ecx, ecx
            //   52                   | push                edx

        $sequence_8 = { 7433 8d4e01 51 6a40 }
            // n = 4, score = 300
            //   7433                 | je                  0x35
            //   8d4e01               | lea                 ecx, [esi + 1]
            //   51                   | push                ecx
            //   6a40                 | push                0x40

        $sequence_9 = { 8d8dfcfffeff 51 68???????? eb23 83f802 }
            // n = 5, score = 300
            //   8d8dfcfffeff         | lea                 ecx, [ebp - 0x10004]
            //   51                   | push                ecx
            //   68????????           |                     
            //   eb23                 | jmp                 0x25
            //   83f802               | cmp                 eax, 2

    condition:
        7 of them and filesize < 303104
}