rule win_boaxxe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.boaxxe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.boaxxe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc3 e8???????? 8d55d8 66b89a01 e8???????? ff75d8 68???????? }
            // n = 7, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8d55d8               | lea                 edx, [ebp - 0x28]
            //   66b89a01             | mov                 ax, 0x19a
            //   e8????????           |                     
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   68????????           |                     

        $sequence_1 = { 8b542404 8bc7 e8???????? 8bce 03c9 8b442404 8d1458 }
            // n = 7, score = 100
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   03c9                 | add                 ecx, ecx
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8d1458               | lea                 edx, [eax + ebx*2]

        $sequence_2 = { 85c0 7410 8bc3 8bd4 b905010000 e8???????? eb0d }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12
            //   8bc3                 | mov                 eax, ebx
            //   8bd4                 | mov                 edx, esp
            //   b905010000           | mov                 ecx, 0x105
            //   e8????????           |                     
            //   eb0d                 | jmp                 0xf

        $sequence_3 = { 6a01 e8???????? 8bd8 bd80000008 85f6 740d 81ff00040000 }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   bd80000008           | mov                 ebp, 0x8000080
            //   85f6                 | test                esi, esi
            //   740d                 | je                  0xf
            //   81ff00040000         | cmp                 edi, 0x400

        $sequence_4 = { 64ff30 648920 8b55f0 a1???????? e8???????? 8b55f0 a1???????? }
            // n = 7, score = 100
            //   64ff30               | push                dword ptr fs:[eax]
            //   648920               | mov                 dword ptr fs:[eax], esp
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   a1????????           |                     
            //   e8????????           |                     
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   a1????????           |                     

        $sequence_5 = { 8b4078 85c0 7420 8b54240c 8d0402 89442408 8bc6 }
            // n = 7, score = 100
            //   8b4078               | mov                 eax, dword ptr [eax + 0x78]
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22
            //   8b54240c             | mov                 edx, dword ptr [esp + 0xc]
            //   8d0402               | lea                 eax, [edx + eax]
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8bc6                 | mov                 eax, esi

        $sequence_6 = { 8b5df8 03de 8a1b 8b7dfc 03f9 301f 46 }
            // n = 7, score = 100
            //   8b5df8               | mov                 ebx, dword ptr [ebp - 8]
            //   03de                 | add                 ebx, esi
            //   8a1b                 | mov                 bl, byte ptr [ebx]
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   03f9                 | add                 edi, ecx
            //   301f                 | xor                 byte ptr [edi], bl
            //   46                   | inc                 esi

        $sequence_7 = { 7411 803c24ac 7507 807c240110 7404 33c0 5a }
            // n = 7, score = 100
            //   7411                 | je                  0x13
            //   803c24ac             | cmp                 byte ptr [esp], 0xac
            //   7507                 | jne                 9
            //   807c240110           | cmp                 byte ptr [esp + 1], 0x10
            //   7404                 | je                  6
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx

        $sequence_8 = { e8???????? 8d45d8 8b55ec e8???????? 8d45d8 8b4df4 8b55f8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_9 = { 83c9ff 32c0 f2ae f7d1 5f 92 f2ae }
            // n = 7, score = 100
            //   83c9ff               | or                  ecx, 0xffffffff
            //   32c0                 | xor                 al, al
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   5f                   | pop                 edi
            //   92                   | xchg                eax, edx
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

    condition:
        7 of them and filesize < 1146880
}