rule win_bohmini_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bohmini."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bohmini"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd5 85c0 7503 ff430c 8b36 85f6 }
            // n = 6, score = 100
            //   ffd5                 | call                ebp
            //   85c0                 | test                eax, eax
            //   7503                 | jne                 5
            //   ff430c               | inc                 dword ptr [ebx + 0xc]
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   85f6                 | test                esi, esi

        $sequence_1 = { 8d442408 c744240824020000 50 56 e8???????? 85c0 741f }
            // n = 7, score = 100
            //   8d442408             | lea                 eax, [esp + 8]
            //   c744240824020000     | mov                 dword ptr [esp + 8], 0x224
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   741f                 | je                  0x21

        $sequence_2 = { 57 51 6a00 6a00 ff15???????? 85c0 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { 50 8d542424 51 52 8d442424 6aff 50 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d542424             | lea                 edx, [esp + 0x24]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   6aff                 | push                -1
            //   50                   | push                eax

        $sequence_4 = { 33d0 8855fc 8d742600 8b4df0 034df8 8a55fc 8811 }
            // n = 7, score = 100
            //   33d0                 | xor                 edx, eax
            //   8855fc               | mov                 byte ptr [ebp - 4], dl
            //   8d742600             | lea                 esi, [esi]
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   034df8               | add                 ecx, dword ptr [ebp - 8]
            //   8a55fc               | mov                 dl, byte ptr [ebp - 4]
            //   8811                 | mov                 byte ptr [ecx], dl

        $sequence_5 = { c74424080c000000 c744241000000000 8944240c ff15???????? 8b542404 }
            // n = 5, score = 100
            //   c74424080c000000     | mov                 dword ptr [esp + 8], 0xc
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   ff15????????         |                     
            //   8b542404             | mov                 edx, dword ptr [esp + 4]

        $sequence_6 = { 85c0 7529 8d442400 56 50 e8???????? 8bf0 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7529                 | jne                 0x2b
            //   8d442400             | lea                 eax, [esp]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_7 = { ffd6 8b3d???????? 50 ffd7 55 6a00 }
            // n = 6, score = 100
            //   ffd6                 | call                esi
            //   8b3d????????         |                     
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   55                   | push                ebp
            //   6a00                 | push                0

        $sequence_8 = { 837e0c0a 7e47 8b4e08 51 e8???????? 83c404 }
            // n = 6, score = 100
            //   837e0c0a             | cmp                 dword ptr [esi + 0xc], 0xa
            //   7e47                 | jle                 0x49
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_9 = { 8d442418 50 56 e8???????? eb0b }
            // n = 5, score = 100
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   eb0b                 | jmp                 0xd

    condition:
        7 of them and filesize < 139264
}