rule win_boldmove_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.boldmove."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.boldmove"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4308 890424 ff15???????? 50 50 8b4308 890424 }
            // n = 7, score = 100
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   ff15????????         |                     
            //   50                   | push                eax
            //   50                   | push                eax
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_1 = { 83e104 89442454 894c2418 0f852f0e0000 }
            // n = 4, score = 100
            //   83e104               | and                 ecx, 4
            //   89442454             | mov                 dword ptr [esp + 0x54], eax
            //   894c2418             | mov                 dword ptr [esp + 0x18], ecx
            //   0f852f0e0000         | jne                 0xe35

        $sequence_2 = { 56 53 83ec20 e8???????? a1???????? dd5df0 83780c00 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   53                   | push                ebx
            //   83ec20               | sub                 esp, 0x20
            //   e8????????           |                     
            //   a1????????           |                     
            //   dd5df0               | fstp                qword ptr [ebp - 0x10]
            //   83780c00             | cmp                 dword ptr [eax + 0xc], 0

        $sequence_3 = { d9ee 8b5c245c 8944245c 83c701 dbe9 897c2434 }
            // n = 6, score = 100
            //   d9ee                 | fldz                
            //   8b5c245c             | mov                 ebx, dword ptr [esp + 0x5c]
            //   8944245c             | mov                 dword ptr [esp + 0x5c], eax
            //   83c701               | add                 edi, 1
            //   dbe9                 | fucomi              st(1)
            //   897c2434             | mov                 dword ptr [esp + 0x34], edi

        $sequence_4 = { 8b449908 85c0 7415 890424 e8???????? a1???????? c744980800000000 }
            // n = 7, score = 100
            //   8b449908             | mov                 eax, dword ptr [ecx + ebx*4 + 8]
            //   85c0                 | test                eax, eax
            //   7415                 | je                  0x17
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   a1????????           |                     
            //   c744980800000000     | mov                 dword ptr [eax + ebx*4 + 8], 0

        $sequence_5 = { c7042404000000 e8???????? c7434000000000 89433c e8???????? dd5b08 0fb617 }
            // n = 7, score = 100
            //   c7042404000000       | mov                 dword ptr [esp], 4
            //   e8????????           |                     
            //   c7434000000000       | mov                 dword ptr [ebx + 0x40], 0
            //   89433c               | mov                 dword ptr [ebx + 0x3c], eax
            //   e8????????           |                     
            //   dd5b08               | fstp                qword ptr [ebx + 8]
            //   0fb617               | movzx               edx, byte ptr [edi]

        $sequence_6 = { 8d85c8fbffff c744240c07000000 89442408 c744240400040000 893424 e8???????? 8b85c8fbffff }
            // n = 7, score = 100
            //   8d85c8fbffff         | lea                 eax, [ebp - 0x438]
            //   c744240c07000000     | mov                 dword ptr [esp + 0xc], 7
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c744240400040000     | mov                 dword ptr [esp + 4], 0x400
            //   893424               | mov                 dword ptr [esp], esi
            //   e8????????           |                     
            //   8b85c8fbffff         | mov                 eax, dword ptr [ebp - 0x438]

        $sequence_7 = { 66250045 663d0005 0f84f3040000 6681e2ff7f }
            // n = 4, score = 100
            //   66250045             | and                 ax, 0x4500
            //   663d0005             | cmp                 ax, 0x500
            //   0f84f3040000         | je                  0x4f9
            //   6681e2ff7f           | and                 dx, 0x7fff

        $sequence_8 = { 39f0 b800000000 0f47d0 8d440b04 01d9 89442404 89542408 }
            // n = 7, score = 100
            //   39f0                 | cmp                 eax, esi
            //   b800000000           | mov                 eax, 0
            //   0f47d0               | cmova               edx, eax
            //   8d440b04             | lea                 eax, [ebx + ecx + 4]
            //   01d9                 | add                 ecx, ebx
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   89542408             | mov                 dword ptr [esp + 8], edx

        $sequence_9 = { d905???????? d9c1 d8c1 d9cb dbf3 dddb 0f87a7030000 }
            // n = 7, score = 100
            //   d905????????         |                     
            //   d9c1                 | fld                 st(1)
            //   d8c1                 | fadd                st(1)
            //   d9cb                 | fxch                st(3)
            //   dbf3                 | fcomi               st(3)
            //   dddb                 | fstp                st(3)
            //   0f87a7030000         | ja                  0x3ad

    condition:
        7 of them and filesize < 242688
}