rule win_bookcodesrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bookcodesrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bookcodesrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c785f8010000097c504a 66c785fc0100004c4a c685fe0100006a 8845c8 488945c9 8945d1 668945d5 }
            // n = 7, score = 100
            //   c785f8010000097c504a     | nop    dword ptr [eax + eax]
            //   66c785fc0100004c4a     | ror    ecx, 0xd
            //   c685fe0100006a       | movsx               eax, al
            //   8845c8               | dec                 eax
            //   488945c9             | inc                 edx
            //   8945d1               | add                 ecx, eax
            //   668945d5             | xor                 ecx, ecx

        $sequence_1 = { 33d2 41b848090000 897c2444 897c2440 e8???????? 41ff942490000000 488d4c2444 }
            // n = 7, score = 100
            //   33d2                 | dec                 esp
            //   41b848090000         | mov                 esp, dword ptr [esp + 0x60]
            //   897c2444             | dec                 eax
            //   897c2440             | mov                 edi, dword ptr [esp + 0x58]
            //   e8????????           |                     
            //   41ff942490000000     | dec                 eax
            //   488d4c2444           | add                 esp, 0x28

        $sequence_2 = { 4883c002 bf0c000000 488906 eb05 bf0b000000 488d4c2420 488bd3 }
            // n = 7, score = 100
            //   4883c002             | dec                 eax
            //   bf0c000000           | lea                 ecx, [ebp - 0x70]
            //   488906               | dec                 eax
            //   eb05                 | lea                 edi, [ebp - 0x40]
            //   bf0b000000           | repne scasb         al, byte ptr es:[edi]
            //   488d4c2420           | dec                 eax
            //   488bd3               | not                 ecx

        $sequence_3 = { 33d2 41b808020000 e8???????? 0fb754245c 0fb74c2458 0fb744245a 0fb77c2456 }
            // n = 7, score = 100
            //   33d2                 | add                 esp, 0x20
            //   41b808020000         | pop                 edi
            //   e8????????           |                     
            //   0fb754245c           | ret                 
            //   0fb74c2458           | dec                 eax
            //   0fb744245a           | sub                 esi, ebx
            //   0fb77c2456           | nop                 word ptr [eax + eax]

        $sequence_4 = { e8???????? cc 8b4b28 488b4308 498bd4 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   cc                   | inc                 esp
            //   8b4b28               | mov                 dword ptr [esp + 0x28], esp
            //   488b4308             | mov                 dword ptr [esp + 0x20], esi
            //   498bd4               | dec                 eax

        $sequence_5 = { 4885c9 7406 ff15???????? 4883bb7002000008 720c 488b8b58020000 e8???????? }
            // n = 7, score = 100
            //   4885c9               | dec                 eax
            //   7406                 | mov                 dword ptr [ebp + 0x1d0], eax
            //   ff15????????         |                     
            //   4883bb7002000008     | dec                 esp
            //   720c                 | mov                 ebp, edx
            //   488b8b58020000       | dec                 eax
            //   e8????????           |                     

        $sequence_6 = { 488bd0 e8???????? 89442438 41b901000000 488d8b30330000 488d542438 458d4103 }
            // n = 7, score = 100
            //   488bd0               | dec                 esp
            //   e8????????           |                     
            //   89442438             | lea                 eax, [ecx + ecx]
            //   41b901000000         | dec                 eax
            //   488d8b30330000       | lea                 ecx, [ebp + 0x1a4]
            //   488d542438           | lea                 eax, [edi + 2]
            //   458d4103             | mov                 dword ptr [ebp + 0x1a0], eax

        $sequence_7 = { 66f2af 48f7d1 4c8d41ff 488d55c0 488d4d90 e8???????? }
            // n = 6, score = 100
            //   66f2af               | je                  0x873
            //   48f7d1               | dec                 eax
            //   4c8d41ff             | cmp                 dword ptr [ebx + 0x3840], 0
            //   488d55c0             | je                  0x873
            //   488d4d90             | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 488bf1 488d151bbd0200 488d0d30d50200 e8???????? 4883c9ff 488bfe 488bd8 }
            // n = 7, score = 100
            //   488bf1               | dec                 eax
            //   488d151bbd0200       | mov                 dword ptr [esp + 0x28], eax
            //   488d0d30d50200       | xor                 edx, edx
            //   e8????????           |                     
            //   4883c9ff             | dec                 eax
            //   488bfe               | mov                 ecx, ebx
            //   488bd8               | dec                 eax

        $sequence_9 = { 32c2 ffc2 3433 428884058f070000 83fa14 7ce4 4863c2 }
            // n = 7, score = 100
            //   32c2                 | cmp                 dword ptr [esi + 0x30], 0
            //   ffc2                 | dec                 eax
            //   3433                 | mov                 edx, dword ptr [edx + eax*8]
            //   428884058f070000     | je                  0x1f0c
            //   83fa14               | dec                 eax
            //   7ce4                 | mov                 eax, dword ptr [ebp + esi*8 + 8]
            //   4863c2               | dec                 ecx

    condition:
        7 of them and filesize < 544768
}