rule win_bouncer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bouncer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bouncer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8441050000 50 ff75fc e8???????? 59 59 }
            // n = 6, score = 200
            //   0f8441050000         | je                  0x547
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_1 = { 8b85b4feffff 48 3bc8 731b }
            // n = 4, score = 200
            //   8b85b4feffff         | mov                 eax, dword ptr [ebp - 0x14c]
            //   48                   | dec                 eax
            //   3bc8                 | cmp                 ecx, eax
            //   731b                 | jae                 0x1d

        $sequence_2 = { 50 ff15???????? 8d85a4fdffff c645dc17 50 e8???????? 83c414 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   c645dc17             | mov                 byte ptr [ebp - 0x24], 0x17
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14

        $sequence_3 = { c3 55 8bec 83ec24 56 8b750c }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec24               | sub                 esp, 0x24
            //   56                   | push                esi
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]

        $sequence_4 = { 53 8b5d10 56 57 8b7d0c 7410 a0???????? }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   7410                 | je                  0x12
            //   a0????????           |                     

        $sequence_5 = { 8bd8 3bde 7d13 68???????? ff15???????? }
            // n = 5, score = 200
            //   8bd8                 | mov                 ebx, eax
            //   3bde                 | cmp                 ebx, esi
            //   7d13                 | jge                 0x15
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_6 = { 56 56 ff15???????? 8d859cf6ffff 50 8d859cf8ffff 68???????? }
            // n = 7, score = 200
            //   56                   | push                esi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d859cf6ffff         | lea                 eax, [ebp - 0x964]
            //   50                   | push                eax
            //   8d859cf8ffff         | lea                 eax, [ebp - 0x764]
            //   68????????           |                     

        $sequence_7 = { 50 ff15???????? 83c40c eb2e ff7508 ff15???????? }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   eb2e                 | jmp                 0x30
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     

        $sequence_8 = { 7e33 8d85f4feffff 50 56 e8???????? 85c0 7422 }
            // n = 7, score = 200
            //   7e33                 | jle                 0x35
            //   8d85f4feffff         | lea                 eax, [ebp - 0x10c]
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7422                 | je                  0x24

        $sequence_9 = { 3bc6 59 a3???????? 750c 50 ff15???????? }
            // n = 6, score = 200
            //   3bc6                 | cmp                 eax, esi
            //   59                   | pop                 ecx
            //   a3????????           |                     
            //   750c                 | jne                 0xe
            //   50                   | push                eax
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 335872
}