rule win_bqtlock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bqtlock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bqtlock"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f859b000000 8b08 e8???????? 6690 4c89e1 e8???????? 48c745e800000000 }
            // n = 7, score = 100
            //   0f859b000000         | dec                 esp
            //   8b08                 | mov                 ecx, dword ptr [ecx + 0x18]
            //   e8????????           |                     
            //   6690                 | mov                 eax, dword ptr [ecx + 0x28]
            //   4c89e1               | dec                 ebp
            //   e8????????           |                     
            //   48c745e800000000     | lea                 ebx, [ecx + 2]

        $sequence_1 = { 498d5508 4c89c1 4829d1 83e108 742f 498b5508 4839d0 }
            // n = 7, score = 100
            //   498d5508             | dec                 ecx
            //   4c89c1               | mov                 ecx, ecx
            //   4829d1               | inc                 ecx
            //   83e108               | mov                 eax, 1
            //   742f                 | mov                 edx, 0xffffffff
            //   498b5508             | dec                 eax
            //   4839d0               | mov                 ecx, eax

        $sequence_2 = { 488d540002 e8???????? 488b4ba0 4885c9 7405 e8???????? 488b4500 }
            // n = 7, score = 100
            //   488d540002           | mov                 edi, eax
            //   e8????????           |                     
            //   488b4ba0             | dec                 esp
            //   4885c9               | lea                 ecx, [esp + 0x20]
            //   7405                 | dec                 ecx
            //   e8????????           |                     
            //   488b4500             | mov                 eax, ebx

        $sequence_3 = { 4d85c0 48895110 4889cb 0f95c0 31d2 894108 488d057fde0a00 }
            // n = 7, score = 100
            //   4d85c0               | mov                 dword ptr [esp + 0x90], ebx
            //   48895110             | dec                 eax
            //   4889cb               | mov                 edx, dword ptr [esp + 0x50]
            //   0f95c0               | mov                 byte ptr [esp + 0xa0], 0
            //   31d2                 | je                  0x1a7
            //   894108               | dec                 esp
            //   488d057fde0a00       | mov                 dword ptr [esp + 0x30], ebp

        $sequence_4 = { 4c89d9 ff5048 83f8ff 0f8451020000 4c8b5c2468 89c1 0fb6d0 }
            // n = 7, score = 100
            //   4c89d9               | dec                 esp
            //   ff5048               | mov                 dword ptr [esp + 0x80], esp
            //   83f8ff               | mov                 dword ptr [esp + 0x38], edx
            //   0f8451020000         | dec                 eax
            //   4c8b5c2468           | mov                 edx, ecx
            //   89c1                 | dec                 eax
            //   0fb6d0               | mov                 ecx, dword ptr [esp + 0x60]

        $sequence_5 = { 4c8d742450 4531d2 4c894c2438 4c89e9 4c89742440 48c744244800000000 664489542450 }
            // n = 7, score = 100
            //   4c8d742450           | dec                 eax
            //   4531d2               | mov                 dword ptr [esp + 0x68], eax
            //   4c894c2438           | xor                 eax, eax
            //   4c89e9               | movzx               eax, byte ptr [esp + 0xc0]
            //   4c89742440           | dec                 eax
            //   48c744244800000000     | lea    ecx, [0xdc4a4]
            //   664489542450         | movups              xmmword ptr [esp + 0x50], xmm2

        $sequence_6 = { 488d4110 488901 4885d2 7505 4d85c0 7510 4531c9 }
            // n = 7, score = 100
            //   488d4110             | dec                 eax
            //   488901               | lea                 ecx, [eax + ecx*2]
            //   4885d2               | dec                 ecx
            //   7505                 | cmp                 eax, 1
            //   4d85c0               | je                  0x805
            //   7510                 | dec                 ebp
            //   4531c9               | add                 eax, eax

        $sequence_7 = { 4c8d0daa38fcff 488b4038 4c39c8 0f856d030000 4839f2 740b 4889f2 }
            // n = 7, score = 100
            //   4c8d0daa38fcff       | dec                 esp
            //   488b4038             | mov                 dword ptr [esp + 0x30], eax
            //   4c39c8               | dec                 esp
            //   0f856d030000         | mov                 edx, dword ptr [edx + 0x28]
            //   4839f2               | dec                 ebp
            //   740b                 | mov                 ebx, edx
            //   4889f2               | dec                 ebp

        $sequence_8 = { b800000000 ba00000000 480f45542460 410f44c6 4889542460 4038f0 0f84fdfaffff }
            // n = 7, score = 100
            //   b800000000           | dec                 eax
            //   ba00000000           | lea                 eax, [ebp + 0x760]
            //   480f45542460         | inc                 ecx
            //   410f44c6             | mov                 eax, 0x104
            //   4889542460           | dec                 eax
            //   4038f0               | mov                 edx, eax
            //   0f84fdfaffff         | mov                 ecx, 0

        $sequence_9 = { 4d85c0 0f8469fdffff e9???????? e8???????? 4889c3 ff542438 8b00 }
            // n = 7, score = 100
            //   4d85c0               | cmp                 edi, esi
            //   0f8469fdffff         | setb                al
            //   e9????????           |                     
            //   e8????????           |                     
            //   4889c3               | and                 edx, eax
            //   ff542438             | mov                 byte ptr [esp + 0x68], dl
            //   8b00                 | dec                 esp

    condition:
        7 of them and filesize < 4444160
}