rule win_brbbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.brbbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.brbbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d0d14310000 4533c9 ba00000040 4489442420 ff15???????? 488905???????? }
            // n = 6, score = 100
            //   488d0d14310000       | lock dec            dword ptr [ecx]
            //   4533c9               | test                eax, eax
            //   ba00000040           | jne                 0x6b7
            //   4489442420           | dec                 esp
            //   ff15????????         |                     
            //   488905????????       |                     

        $sequence_1 = { 4c8d41ff 488b4d00 e8???????? 443926 7433 488b4d00 488d15e1ca0000 }
            // n = 7, score = 100
            //   4c8d41ff             | cmp                 eax, -1
            //   488b4d00             | jne                 0x157b
            //   e8????????           |                     
            //   443926               | dec                 esp
            //   7433                 | lea                 esp, [0xb31b]
            //   488b4d00             | mov                 edx, ebx
            //   488d15e1ca0000       | dec                 esp

        $sequence_2 = { 8b4d48 41b801000000 4883caff e8???????? 807d580a 4c8d05af3dffff 740f }
            // n = 7, score = 100
            //   8b4d48               | dec                 eax
            //   41b801000000         | mov                 edi, ebx
            //   4883caff             | jle                 0x424
            //   e8????????           |                     
            //   807d580a             | movzx               ebx, ax
            //   4c8d05af3dffff       | or                  ebx, 0x80070000
            //   740f                 | inc                 ebp

        $sequence_3 = { 488906 8b05???????? 894608 0fb705???????? 6689460c 488bc6 660f1f440000 }
            // n = 7, score = 100
            //   488906               | cmp                 edx, ebx
            //   8b05????????         |                     
            //   894608               | jb                  0x1284
            //   0fb705????????       |                     
            //   6689460c             | lea                 edi, [ebx + ebx + 1]
            //   488bc6               | dec                 eax
            //   660f1f440000         | inc                 edx

        $sequence_4 = { 48ffcf 75f5 488bce e8???????? 488bf8 }
            // n = 5, score = 100
            //   48ffcf               | cmp                 eax, ebx
            //   75f5                 | mov                 ebx, dword ptr [ebp - 0x20]
            //   488bce               | dec                 eax
            //   e8????????           |                     
            //   488bf8               | lea                 eax, [0xffff3c49]

        $sequence_5 = { 81cb00000780 8bc3 4883c448 5f 5b c3 4c8d0562ec0000 }
            // n = 7, score = 100
            //   81cb00000780         | mov                 edi, ebx
            //   8bc3                 | dec                 esp
            //   4883c448             | mov                 esp, ebx
            //   5f                   | dec                 eax
            //   5b                   | lea                 eax, [0xc37e]
            //   c3                   | dec                 ecx
            //   4c8d0562ec0000       | sar                 esp, 5

        $sequence_6 = { 57 4881ece0010000 488b05???????? 4833c4 48898424d0010000 33ff 33c9 }
            // n = 7, score = 100
            //   57                   | mov                 eax, 0x3e8
            //   4881ece0010000       | dec                 eax
            //   488b05????????       |                     
            //   4833c4               | mov                 ecx, eax
            //   48898424d0010000     | dec                 eax
            //   33ff                 | mov                 esi, eax
            //   33c9                 | dec                 eax

        $sequence_7 = { 7516 488d051cb80000 488b4c2430 483bc8 7405 e8???????? }
            // n = 6, score = 100
            //   7516                 | mov                 ebx, eax
            //   488d051cb80000       | inc                 ecx
            //   488b4c2430           | mov                 edx, esp
            //   483bc8               | dec                 eax
            //   7405                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_8 = { 750d 488bce e8???????? e9???????? 4c8d2d31bb0000 8bcb 488beb }
            // n = 7, score = 100
            //   750d                 | dec                 eax
            //   488bce               | lea                 ecx, [esp + 0x150]
            //   e8????????           |                     
            //   e9????????           |                     
            //   4c8d2d31bb0000       | inc                 ebp
            //   8bcb                 | xor                 eax, eax
            //   488beb               | dec                 eax

        $sequence_9 = { 8a45d9 4b8b8cf8c05a0100 88443139 4b8b84f8c05a0100 8854303a eb4c }
            // n = 6, score = 100
            //   8a45d9               | mov                 dword ptr [esp + 0x28], ebx
            //   4b8b8cf8c05a0100     | inc                 ebp
            //   88443139             | xor                 ecx, ecx
            //   4b8b84f8c05a0100     | dec                 eax
            //   8854303a             | mov                 ecx, eax
            //   eb4c                 | mov                 dword ptr [esp + 0x20], edi

    condition:
        7 of them and filesize < 198656
}