rule win_breakthrough_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.breakthrough_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.breakthrough_loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb06 8b3d???????? 8b4df4 85c9 7403 }
            // n = 5, score = 100
            //   eb06                 | jmp                 8
            //   8b3d????????         |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   85c9                 | test                ecx, ecx
            //   7403                 | je                  5

        $sequence_1 = { 50 57 ff15???????? 85c0 740a ba???????? e8???????? }
            // n = 7, score = 100
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   ba????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 83c408 83f8ff 742a 8b75f8 8bce 8935???????? }
            // n = 6, score = 100
            //   83c408               | add                 esp, 8
            //   83f8ff               | cmp                 eax, -1
            //   742a                 | je                  0x2c
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   8bce                 | mov                 ecx, esi
            //   8935????????         |                     

        $sequence_3 = { ff5220 83e800 7412 83e801 7411 8b4c2424 }
            // n = 6, score = 100
            //   ff5220               | call                dword ptr [edx + 0x20]
            //   83e800               | sub                 eax, 0
            //   7412                 | je                  0x14
            //   83e801               | sub                 eax, 1
            //   7411                 | je                  0x13
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]

        $sequence_4 = { 56 57 8965f0 8955dc bb???????? 895de4 33ff }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx
            //   bb????????           |                     
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   33ff                 | xor                 edi, edi

        $sequence_5 = { 7408 8b10 8bc8 6a01 ff12 5f 5e }
            // n = 7, score = 100
            //   7408                 | je                  0xa
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8bc8                 | mov                 ecx, eax
            //   6a01                 | push                1
            //   ff12                 | call                dword ptr [edx]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 8b048540354500 f644012880 745d 8d45d8 50 ff75e4 ff15???????? }
            // n = 7, score = 100
            //   8b048540354500       | mov                 eax, dword ptr [eax*4 + 0x453540]
            //   f644012880           | test                byte ptr [ecx + eax + 0x28], 0x80
            //   745d                 | je                  0x5f
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff15????????         |                     

        $sequence_7 = { 85c0 7fb4 837dc810 8d4db4 0f434db4 33c0 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7fb4                 | jg                  0xffffffb6
            //   837dc810             | cmp                 dword ptr [ebp - 0x38], 0x10
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   0f434db4             | cmovae              ecx, dword ptr [ebp - 0x4c]
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { ff75e4 e8???????? 8b7508 c746140f000000 }
            // n = 4, score = 100
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf

        $sequence_9 = { 895de4 8b049d40354500 8945d4 8955e8 8a5c1029 }
            // n = 5, score = 100
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   8b049d40354500       | mov                 eax, dword ptr [ebx*4 + 0x453540]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   8a5c1029             | mov                 bl, byte ptr [eax + edx + 0x29]

    condition:
        7 of them and filesize < 753664
}