rule win_bredolab_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bredolab."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bredolab"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 55 89e5 56 53 8b5508 8b4d0c }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   56                   | push                esi
            //   53                   | push                ebx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_1 = { 75be 8b8348080000 40 898348080000 }
            // n = 4, score = 200
            //   75be                 | jne                 0xffffffc0
            //   8b8348080000         | mov                 eax, dword ptr [ebx + 0x848]
            //   40                   | inc                 eax
            //   898348080000         | mov                 dword ptr [ebx + 0x848], eax

        $sequence_2 = { 7424 8b5514 c60200 8d85e0f7ffff 89442404 c7042400080000 ff15???????? }
            // n = 7, score = 200
            //   7424                 | je                  0x26
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   c60200               | mov                 byte ptr [edx], 0
            //   8d85e0f7ffff         | lea                 eax, [ebp - 0x820]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   c7042400080000       | mov                 dword ptr [esp], 0x800
            //   ff15????????         |                     

        $sequence_3 = { 89853cfcffff ff15???????? 51 66c78560ffffff0800 c744240408020000 c7042400000000 ff15???????? }
            // n = 7, score = 200
            //   89853cfcffff         | mov                 dword ptr [ebp - 0x3c4], eax
            //   ff15????????         |                     
            //   51                   | push                ecx
            //   66c78560ffffff0800     | mov    word ptr [ebp - 0xa0], 8
            //   c744240408020000     | mov                 dword ptr [esp + 4], 0x208
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   ff15????????         |                     

        $sequence_4 = { c7834808000000000000 c7442404???????? 8d4314 890424 ff15???????? }
            // n = 5, score = 200
            //   c7834808000000000000     | mov    dword ptr [ebx + 0x848], 0
            //   c7442404????????     |                     
            //   8d4314               | lea                 eax, [ebx + 0x14]
            //   890424               | mov                 dword ptr [esp], eax
            //   ff15????????         |                     

        $sequence_5 = { ff15???????? 57 57 8b45e4 89442404 8b4510 890424 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   57                   | push                edi
            //   57                   | push                edi
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_6 = { 895c2424 89542420 c744241c00000000 c744241800000000 }
            // n = 4, score = 200
            //   895c2424             | mov                 dword ptr [esp + 0x24], ebx
            //   89542420             | mov                 dword ptr [esp + 0x20], edx
            //   c744241c00000000     | mov                 dword ptr [esp + 0x1c], 0
            //   c744241800000000     | mov                 dword ptr [esp + 0x18], 0

        $sequence_7 = { 84c0 75f6 894d14 8b5d14 c60300 8b4d0c 8b8560ffffff }
            // n = 7, score = 200
            //   84c0                 | test                al, al
            //   75f6                 | jne                 0xfffffff8
            //   894d14               | mov                 dword ptr [ebp + 0x14], ecx
            //   8b5d14               | mov                 ebx, dword ptr [ebp + 0x14]
            //   c60300               | mov                 byte ptr [ebx], 0
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b8560ffffff         | mov                 eax, dword ptr [ebp - 0xa0]

        $sequence_8 = { 8b450c 8b5510 8d1c07 85c0 740a 807bff3f 7404 }
            // n = 7, score = 200
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   8d1c07               | lea                 ebx, [edi + eax]
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   807bff3f             | cmp                 byte ptr [ebx - 1], 0x3f
            //   7404                 | je                  6

        $sequence_9 = { 89d6 31db 6690 80be5409000000 7523 b030 }
            // n = 6, score = 200
            //   89d6                 | mov                 esi, edx
            //   31db                 | xor                 ebx, ebx
            //   6690                 | nop                 
            //   80be5409000000       | cmp                 byte ptr [esi + 0x954], 0
            //   7523                 | jne                 0x25
            //   b030                 | mov                 al, 0x30

    condition:
        7 of them and filesize < 90112
}