rule win_broomstick_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.broomstick."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.broomstick"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2bc2 83c002 99 83e203 03c2 }
            // n = 5, score = 2200
            //   2bc2                 | sub                 eax, edx
            //   83c002               | add                 eax, 2
            //   99                   | cdq                 
            //   83e203               | and                 edx, 3
            //   03c2                 | add                 eax, edx

        $sequence_1 = { 03f0 56 e8???????? 8b45dc 83c40c c6040600 eb10 }
            // n = 7, score = 2100
            //   03f0                 | mov                 dword ptr [esi + 0x70], 0
            //   56                   | movzx               ecx, byte ptr [eax]
            //   e8????????           |                     
            //   8b45dc               | inc                 eax
            //   83c40c               | jbe                 0xfffffff6
            //   c6040600             | sub                 eax, edx
            //   eb10                 | add                 eax, 2

        $sequence_2 = { 83c40c c6040600 eb10 c645dc00 ff75dc 51 8d4dc0 }
            // n = 7, score = 2100
            //   83c40c               | sar                 eax, 2
            //   c6040600             | jbe                 0xfffffff5
            //   eb10                 | sub                 eax, edx
            //   c645dc00             | add                 eax, 2
            //   ff75dc               | cdq                 
            //   51                   | and                 edx, 3
            //   8d4dc0               | jbe                 0xfffffff5

        $sequence_3 = { c6400100 8808 eb13 ff75e8 }
            // n = 4, score = 2100
            //   c6400100             | mov                 byte ptr [ebp - 0x24], 0
            //   8808                 | push                dword ptr [ebp - 0x24]
            //   eb13                 | push                ecx
            //   ff75e8               | mov                 byte ptr [esi + eax], 0

        $sequence_4 = { 51 50 51 8bce e8???????? 8b4dec }
            // n = 6, score = 2100
            //   51                   | mov                 dword ptr [esi + 0x74], 7
            //   50                   | mov                 word ptr [esi + 0x60], ax
            //   51                   | push                eax
            //   8bce                 | add                 esp, 8
            //   e8????????           |                     
            //   8b4dec               | xor                 eax, eax

        $sequence_5 = { 83c408 33c0 c7467000000000 c7467407000000 66894660 }
            // n = 5, score = 2100
            //   83c408               | jbe                 0xfffffff5
            //   33c0                 | sub                 eax, edx
            //   c7467000000000       | add                 eax, 2
            //   c7467407000000       | cdq                 
            //   66894660             | and                 edx, 3

        $sequence_6 = { 8b45d4 8b75d0 2bc6 894ddc 51 52 }
            // n = 6, score = 2100
            //   8b45d4               | add                 esp, 8
            //   8b75d0               | xor                 eax, eax
            //   2bc6                 | mov                 dword ptr [esi + 0x70], 0
            //   894ddc               | mov                 dword ptr [esi + 0x74], 7
            //   51                   | mov                 word ptr [esi + 0x60], ax
            //   52                   | add                 esp, 8

        $sequence_7 = { 80b9????????3f 76f3 2bc2 83c002 }
            // n = 4, score = 2100
            //   80b9????????3f       |                     
            //   76f3                 | add                 eax, edx
            //   2bc2                 | sar                 eax, 2
            //   83c002               | jbe                 0xfffffff5

        $sequence_8 = { 49898688150400 488d4c2428 ffd5 48b80b8b55f8b9616cd5 }
            // n = 4, score = 100
            //   49898688150400       | dec                 ebp
            //   488d4c2428           | mov                 esp, edi
            //   ffd5                 | dec                 ecx
            //   48b80b8b55f8b9616cd5     | mov    dword ptr [esi + 0x36b87], eax

        $sequence_9 = { ba01000000 488bcf ff15???????? ba32ac0600 488bcf ff15???????? }
            // n = 6, score = 100
            //   ba01000000           | mov                 eax, 0xf8558b0b
            //   488bcf               | mov                 ecx, 0x49d56c61
            //   ff15????????         |                     
            //   ba32ac0600           | mov                 dword ptr [esi + 0x41590], eax
            //   488bcf               | dec                 eax
            //   ff15????????         |                     

        $sequence_10 = { 488d4d38 e8???????? 0f57c0 0f114518 }
            // n = 4, score = 100
            //   488d4d38             | dec                 eax
            //   e8????????           |                     
            //   0f57c0               | mov                 eax, edx
            //   0f114518             | and                 edx, 0x3f

        $sequence_11 = { 498986876a0300 4889f1 ba07000000 488b2d???????? }
            // n = 4, score = 100
            //   498986876a0300       | mov                 byte ptr [ebp - 0x24], 0
            //   4889f1               | mov                 edx, dword ptr [ebp - 0x180]
            //   ba07000000           | lea                 ecx, [ecx*2 + 2]
            //   488b2d????????       |                     

        $sequence_12 = { 49898687650300 488d4c2428 41ffd4 4889f1 }
            // n = 4, score = 100
            //   49898687650300       | cmp                 ecx, eax
            //   488d4c2428           | mov                 esi, dword ptr [ebp - 0x30]
            //   41ffd4               | sub                 eax, esi
            //   4889f1               | mov                 dword ptr [ebp - 0x24], ecx

        $sequence_13 = { 4c2bc1 ba2c000000 e8???????? 488bc8 4885c0 }
            // n = 5, score = 100
            //   4c2bc1               | dec                 ebp
            //   ba2c000000           | mov                 ebp, esi
            //   e8????????           |                     
            //   488bc8               | dec                 ecx
            //   4885c0               | sar                 ebp, 6

        $sequence_14 = { ba01000000 488bcf ff15???????? ba08000000 488bcf ff15???????? 48b8e01fcd305c98c076 }
            // n = 7, score = 100
            //   ba01000000           | mov                 ecx, esi
            //   488bcf               | dec                 eax
            //   ff15????????         |                     
            //   ba08000000           | mov                 edx, edi
            //   488bcf               | dec                 ecx
            //   ff15????????         |                     
            //   48b8e01fcd305c98c076     | mov    dword ptr [esi + 0x41488], eax

        $sequence_15 = { ba01000000 488bcf ff15???????? ba58000000 488bcf ff15???????? }
            // n = 6, score = 100
            //   ba01000000           | mov                 ecx, esi
            //   488bcf               | dec                 ecx
            //   ff15????????         |                     
            //   ba58000000           | mov                 dword ptr [esi + 0x41688], eax
            //   488bcf               | mov                 ecx, 0x64d417
            //   ff15????????         |                     

        $sequence_16 = { ba01000000 488bcf ff15???????? ba3a867600 488bcf ff15???????? }
            // n = 6, score = 100
            //   ba01000000           | call                ebp
            //   488bcf               | dec                 ecx
            //   ff15????????         |                     
            //   ba3a867600           | mov                 dword ptr [esi + 0x41688], eax
            //   488bcf               | mov                 ecx, 0x64d417
            //   ff15????????         |                     

        $sequence_17 = { ba01000000 488bcf ff15???????? ba0a000000 488bcf ff15???????? }
            // n = 6, score = 100
            //   ba01000000           | inc                 ecx
            //   488bcf               | call                edi
            //   ff15????????         |                     
            //   ba0a000000           | dec                 eax
            //   488bcf               | mov                 ecx, esi
            //   ff15????????         |                     

        $sequence_18 = { ba01000000 488bcf ff15???????? ba5a000000 488bcf ff15???????? }
            // n = 6, score = 100
            //   ba01000000           | call                esp
            //   488bcf               | dec                 eax
            //   ff15????????         |                     
            //   ba5a000000           | mov                 edi, eax
            //   488bcf               | dec                 eax
            //   ff15????????         |                     

        $sequence_19 = { 498986876b0300 488d4c2428 41ffd7 4d89fc }
            // n = 4, score = 100
            //   498986876b0300       | call                esp
            //   488d4c2428           | dec                 eax
            //   41ffd7               | mov                 ecx, esi
            //   4d89fc               | dec                 ecx

        $sequence_20 = { 49898688160400 b917d46400 41ffd4 4889c7 }
            // n = 4, score = 100
            //   49898688160400       | mov                 edx, 0xf2f09f
            //   b917d46400           | dec                 ecx
            //   41ffd4               | mov                 dword ptr [esi + 0x36b87], eax
            //   4889c7               | dec                 eax

        $sequence_21 = { 49898688320300 b9bc474300 41ffd4 4889c7 }
            // n = 4, score = 100
            //   49898688320300       | mov                 ecx, edi
            //   b9bc474300           | inc                 ecx
            //   41ffd4               | call                edi
            //   4889c7               | dec                 eax

        $sequence_22 = { 0f114540 4c896d50 4c896d58 4533c0 }
            // n = 4, score = 100
            //   0f114540             | movups              xmmword ptr [ebp + 0x40], xmm0
            //   4c896d50             | dec                 esp
            //   4c896d58             | mov                 dword ptr [ebp + 0x50], ebp
            //   4533c0               | dec                 esp

        $sequence_23 = { 4c8d053e920100 488bc2 83e23f 48c1f806 488d0cd2 }
            // n = 5, score = 100
            //   4c8d053e920100       | dec                 esp
            //   488bc2               | mov                 dword ptr [ebp - 0x39], ebp
            //   83e23f               | dec                 eax
            //   48c1f806             | lea                 ecx, [0xfffe3a8f]
            //   488d0cd2             | dec                 esp

        $sequence_24 = { ba01000000 488bcf ff15???????? ba31e7ca00 488bcf ff15???????? }
            // n = 6, score = 100
            //   ba01000000           | mov                 eax, 0xf8558b0b
            //   488bcf               | dec                 ecx
            //   ff15????????         |                     
            //   ba31e7ca00           | mov                 dword ptr [esi + 0x41588], eax
            //   488bcf               | dec                 eax
            //   ff15????????         |                     

        $sequence_25 = { 488d056cc10200 488907 488d057ac10200 0f104318 488b5c2430 }
            // n = 5, score = 100
            //   488d056cc10200       | mov                 ecx, eax
            //   488907               | dec                 eax
            //   488d057ac10200       | test                eax, eax
            //   0f104318             | dec                 esp
            //   488b5c2430           | lea                 eax, [0x1923e]

        $sequence_26 = { ba01000000 488bcf ff15???????? ba6ef90b00 488bcf ff15???????? }
            // n = 6, score = 100
            //   ba01000000           | dec                 eax
            //   488bcf               | mov                 ecx, eax
            //   ff15????????         |                     
            //   ba6ef90b00           | dec                 ecx
            //   488bcf               | mov                 dword ptr [esi + 0x33288], eax
            //   ff15????????         |                     

        $sequence_27 = { 49898688140400 4889f1 4889fa 4c8b3d???????? }
            // n = 4, score = 100
            //   49898688140400       | mov                 edx, 7
            //   4889f1               | call                ebp
            //   4889fa               | mov                 ecx, 0x1759f4
            //   4c8b3d????????       |                     

        $sequence_28 = { 48c7457807000000 0f1006 0f114560 e9???????? }
            // n = 4, score = 100
            //   48c7457807000000     | sub                 eax, ecx
            //   0f1006               | mov                 edx, 0x2c
            //   0f114560             | dec                 eax
            //   e9????????           |                     

        $sequence_29 = { 498986876c0300 4889f9 4c8b3d???????? 41ffd7 }
            // n = 4, score = 100
            //   498986876c0300       | call                ebp
            //   4889f9               | dec                 ecx
            //   4c8b3d????????       |                     
            //   41ffd7               | mov                 dword ptr [esi + 0x36a87], eax

        $sequence_30 = { 498bc6 4d8bee 49c1fd06 4c896dc7 488d0d8f3afeff }
            // n = 5, score = 100
            //   498bc6               | mov                 dword ptr [ebp + 0x58], ebp
            //   4d8bee               | inc                 ebp
            //   49c1fd06             | xor                 eax, eax
            //   4c896dc7             | dec                 ecx
            //   488d0d8f3afeff       | mov                 eax, esi

    condition:
        7 of them and filesize < 1567744
}