rule win_btcware_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.btcware."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.btcware"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85f4faffff 68???????? 50 ffd6 83c418 8d85f0faffff 50 }
            // n = 7, score = 100
            //   8d85f4faffff         | lea                 eax, [ebp - 0x50c]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c418               | add                 esp, 0x18
            //   8d85f0faffff         | lea                 eax, [ebp - 0x510]
            //   50                   | push                eax

        $sequence_1 = { 8b4610 c6040800 83ff03 7ca9 8b7dd8 33db }
            // n = 6, score = 100
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   c6040800             | mov                 byte ptr [eax + ecx], 0
            //   83ff03               | cmp                 edi, 3
            //   7ca9                 | jl                  0xffffffab
            //   8b7dd8               | mov                 edi, dword ptr [ebp - 0x28]
            //   33db                 | xor                 ebx, ebx

        $sequence_2 = { e8???????? 8904bd40d04100 85c0 7514 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8904bd40d04100       | mov                 dword ptr [edi*4 + 0x41d040], eax
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16

        $sequence_3 = { 6888d38101 68???????? 6a00 ffd3 33d2 }
            // n = 5, score = 100
            //   6888d38101           | push                0x181d388
            //   68????????           |                     
            //   6a00                 | push                0
            //   ffd3                 | call                ebx
            //   33d2                 | xor                 edx, edx

        $sequence_4 = { 50 ffb5a0d7ffff ff15???????? 85c0 0f8518feffff }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ffb5a0d7ffff         | push                dword ptr [ebp - 0x2860]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8518feffff         | jne                 0xfffffe1e

        $sequence_5 = { 5d c3 55 8bec 83e4f8 b81c820000 }
            // n = 6, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83e4f8               | and                 esp, 0xfffffff8
            //   b81c820000           | mov                 eax, 0x821c

        $sequence_6 = { b880fd8101 c3 b87cfd8101 c3 53 56 }
            // n = 6, score = 100
            //   b880fd8101           | mov                 eax, 0x181fd80
            //   c3                   | ret                 
            //   b87cfd8101           | mov                 eax, 0x181fd7c
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_7 = { 897df4 3bfb 0f8e6fffffff 83c8ff eb07 8b04cdc42f4100 5f }
            // n = 7, score = 100
            //   897df4               | mov                 dword ptr [ebp - 0xc], edi
            //   3bfb                 | cmp                 edi, ebx
            //   0f8e6fffffff         | jle                 0xffffff75
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb07                 | jmp                 9
            //   8b04cdc42f4100       | mov                 eax, dword ptr [ecx*8 + 0x412fc4]
            //   5f                   | pop                 edi

        $sequence_8 = { c78564ffffff0f000000 c68550ffffff00 83f810 7245 8b8d38ffffff }
            // n = 5, score = 100
            //   c78564ffffff0f000000     | mov    dword ptr [ebp - 0x9c], 0xf
            //   c68550ffffff00       | mov                 byte ptr [ebp - 0xb0], 0
            //   83f810               | cmp                 eax, 0x10
            //   7245                 | jb                  0x47
            //   8b8d38ffffff         | mov                 ecx, dword ptr [ebp - 0xc8]

        $sequence_9 = { 8945e0 8d8058c54100 8945e4 803800 8bc8 7435 8a4101 }
            // n = 7, score = 100
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d8058c54100         | lea                 eax, [eax + 0x41c558]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   803800               | cmp                 byte ptr [eax], 0
            //   8bc8                 | mov                 ecx, eax
            //   7435                 | je                  0x37
            //   8a4101               | mov                 al, byte ptr [ecx + 1]

    condition:
        7 of them and filesize < 458752
}