rule win_bubblewrap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bubblewrap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bubblewrap"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c9ff f2ae f7d1 49 c605????????ee c605????????03 }
            // n = 6, score = 100
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   c605????????ee       |                     
            //   c605????????03       |                     

        $sequence_1 = { c21000 55 68???????? 6a01 6a00 ff15???????? }
            // n = 6, score = 100
            //   c21000               | ret                 0x10
            //   55                   | push                ebp
            //   68????????           |                     
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_2 = { 8915???????? 8b15???????? a3???????? 66a1???????? 880d???????? b910000000 }
            // n = 6, score = 100
            //   8915????????         |                     
            //   8b15????????         |                     
            //   a3????????           |                     
            //   66a1????????         |                     
            //   880d????????         |                     
            //   b910000000           | mov                 ecx, 0x10

        $sequence_3 = { 8bca 89442414 83e103 55 }
            // n = 4, score = 100
            //   8bca                 | mov                 ecx, edx
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   83e103               | and                 ecx, 3
            //   55                   | push                ebp

        $sequence_4 = { 83e103 f3a4 8dbc24ac000000 83c9ff }
            // n = 4, score = 100
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8dbc24ac000000       | lea                 edi, [esp + 0xac]
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_5 = { e8???????? 83c408 be???????? b8???????? 8a10 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   be????????           |                     
            //   b8????????           |                     
            //   8a10                 | mov                 dl, byte ptr [eax]

        $sequence_6 = { c1e902 f3a5 8bca 83e103 f3a4 be???????? b8???????? }
            // n = 7, score = 100
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bca                 | mov                 ecx, edx
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   be????????           |                     
            //   b8????????           |                     

        $sequence_7 = { 8bc1 894c2414 3bc5 0f821cffffff 8b6c2424 b967010000 33c0 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   3bc5                 | cmp                 eax, ebp
            //   0f821cffffff         | jb                  0xffffff22
            //   8b6c2424             | mov                 ebp, dword ptr [esp + 0x24]
            //   b967010000           | mov                 ecx, 0x167
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 8b0d???????? 8b15???????? 894c0435 b920000000 8d742434 bf???????? }
            // n = 6, score = 100
            //   8b0d????????         |                     
            //   8b15????????         |                     
            //   894c0435             | mov                 dword ptr [esp + eax + 0x35], ecx
            //   b920000000           | mov                 ecx, 0x20
            //   8d742434             | lea                 esi, [esp + 0x34]
            //   bf????????           |                     

        $sequence_9 = { 8b15???????? f2ae f7d1 49 bf???????? }
            // n = 5, score = 100
            //   8b15????????         |                     
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   bf????????           |                     

    condition:
        7 of them and filesize < 57136
}