rule win_buer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.buer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.buer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45dc 03c6 89414c 8b45fc 03c7 894150 8b45ec }
            // n = 7, score = 1100
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   03c6                 | add                 eax, esi
            //   89414c               | mov                 dword ptr [ecx + 0x4c], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   03c7                 | add                 eax, edi
            //   894150               | mov                 dword ptr [ecx + 0x50], eax
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_1 = { 8b55e8 015158 8b55d8 894148 }
            // n = 4, score = 1100
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   015158               | add                 dword ptr [ecx + 0x58], edx
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   894148               | mov                 dword ptr [ecx + 0x48], eax

        $sequence_2 = { 8b00 8b4010 8945fc 61 8b45fc }
            // n = 5, score = 1100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   61                   | popal               
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_3 = { 3bc7 7d0f 8a0c46 880c18 40 }
            // n = 5, score = 1100
            //   3bc7                 | cmp                 eax, edi
            //   7d0f                 | jge                 0x11
            //   8a0c46               | mov                 cl, byte ptr [esi + eax*2]
            //   880c18               | mov                 byte ptr [eax + ebx], cl
            //   40                   | inc                 eax

        $sequence_4 = { 8b7b50 8b4340 0345f8 8b5b54 }
            // n = 4, score = 1100
            //   8b7b50               | mov                 edi, dword ptr [ebx + 0x50]
            //   8b4340               | mov                 eax, dword ptr [ebx + 0x40]
            //   0345f8               | add                 eax, dword ptr [ebp - 8]
            //   8b5b54               | mov                 ebx, dword ptr [ebx + 0x54]

        $sequence_5 = { 8b45f4 03c1 8bcb 894144 8b45f0 }
            // n = 5, score = 1100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   03c1                 | add                 eax, ecx
            //   8bcb                 | mov                 ecx, ebx
            //   894144               | mov                 dword ptr [ecx + 0x44], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_6 = { 64a130000000 8b400c 8b4014 8b00 8b4010 }
            // n = 5, score = 1100
            //   64a130000000         | mov                 eax, dword ptr fs:[0x30]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   8b4014               | mov                 eax, dword ptr [eax + 0x14]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]

        $sequence_7 = { 8bc2 eb19 33c0 85d2 7e13 3bc7 7d0f }
            // n = 7, score = 1100
            //   8bc2                 | mov                 eax, edx
            //   eb19                 | jmp                 0x1b
            //   33c0                 | xor                 eax, eax
            //   85d2                 | test                edx, edx
            //   7e13                 | jle                 0x15
            //   3bc7                 | cmp                 eax, edi
            //   7d0f                 | jge                 0x11

        $sequence_8 = { 01cf 29ce 75a7 e9???????? }
            // n = 4, score = 300
            //   01cf                 | add                 edi, ecx
            //   29ce                 | sub                 esi, ecx
            //   75a7                 | jne                 0xffffffa9
            //   e9????????           |                     

        $sequence_9 = { 01de 39d6 0f8384000000 8b742414 }
            // n = 4, score = 300
            //   01de                 | add                 esi, ebx
            //   39d6                 | cmp                 esi, edx
            //   0f8384000000         | jae                 0x8a
            //   8b742414             | mov                 esi, dword ptr [esp + 0x14]

        $sequence_10 = { 01c7 0fa5da d3e3 8b4c2444 }
            // n = 4, score = 300
            //   01c7                 | add                 edi, eax
            //   0fa5da               | shld                edx, ebx, cl
            //   d3e3                 | shl                 ebx, cl
            //   8b4c2444             | mov                 ecx, dword ptr [esp + 0x44]

        $sequence_11 = { 0facd313 884e04 8b74247c 8bc6 8b4c2440 }
            // n = 5, score = 300
            //   0facd313             | shrd                ebx, edx, 0x13
            //   884e04               | mov                 byte ptr [esi + 4], cl
            //   8b74247c             | mov                 esi, dword ptr [esp + 0x7c]
            //   8bc6                 | mov                 eax, esi
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]

        $sequence_12 = { 0fb617 47 89f9 83e23f eb11 }
            // n = 5, score = 300
            //   0fb617               | movzx               edx, byte ptr [edi]
            //   47                   | inc                 edi
            //   89f9                 | mov                 ecx, edi
            //   83e23f               | and                 edx, 0x3f
            //   eb11                 | jmp                 0x13

        $sequence_13 = { 01fe 68???????? e8???????? a1???????? }
            // n = 4, score = 300
            //   01fe                 | add                 esi, edi
            //   68????????           |                     
            //   e8????????           |                     
            //   a1????????           |                     

        $sequence_14 = { 0f82d1000000 83f8fe 0f83d1000000 89d6 }
            // n = 4, score = 300
            //   0f82d1000000         | jb                  0xd7
            //   83f8fe               | cmp                 eax, -2
            //   0f83d1000000         | jae                 0xd7
            //   89d6                 | mov                 esi, edx

        $sequence_15 = { 01de 39c1 0f47c1 89c1 89442420 662e0f1f840000000000 39f9 }
            // n = 7, score = 300
            //   01de                 | add                 esi, ebx
            //   39c1                 | cmp                 ecx, eax
            //   0f47c1               | cmova               eax, ecx
            //   89c1                 | mov                 ecx, eax
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   662e0f1f840000000000     | nop    word ptr cs:[eax + eax]
            //   39f9                 | cmp                 ecx, edi

    condition:
        7 of them and filesize < 3031040
}