rule win_bughatch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bughatch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bughatch"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ec10 8b4508 8945f0 8b4df0 8b5508 03513c 8955f4 }
            // n = 7, score = 100
            //   83ec10               | sub                 esp, 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   03513c               | add                 edx, dword ptr [ecx + 0x3c]
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx

        $sequence_1 = { 8945fc 8d95f8f7ffff 52 e8???????? 83c404 8945f8 8b45f8 }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8d95f8f7ffff         | lea                 edx, [ebp - 0x808]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_2 = { 6a00 e8???????? 83c40c eb41 8b450c 50 68???????? }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb41                 | jmp                 0x43
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_3 = { d1e8 8945f4 8b4d08 894df8 c745fc00000000 eb09 }
            // n = 6, score = 100
            //   d1e8                 | shr                 eax, 1
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   eb09                 | jmp                 0xb

        $sequence_4 = { 6a00 8d4de8 51 6a00 8b55fc }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_5 = { ba01000000 6bc200 c6840588fdffff00 837d0c00 7507 33c0 e9???????? }
            // n = 7, score = 100
            //   ba01000000           | mov                 edx, 1
            //   6bc200               | imul                eax, edx, 0
            //   c6840588fdffff00     | mov                 byte ptr [ebp + eax - 0x278], 0
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     

        $sequence_6 = { ff15???????? 8b4df8 51 ff15???????? 8b45e0 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]

        $sequence_7 = { 6a00 6a00 ff15???????? b904000000 }
            // n = 4, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   b904000000           | mov                 ecx, 4

        $sequence_8 = { 68???????? 8d8d94f7ffff 51 ff15???????? 8b550c }
            // n = 5, score = 100
            //   68????????           |                     
            //   8d8d94f7ffff         | lea                 ecx, [ebp - 0x86c]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_9 = { e9???????? 8d55f0 52 8b45e0 50 8b4de4 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   50                   | push                eax
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]

    condition:
        7 of them and filesize < 75776
}