rule win_bundestrojaner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bundestrojaner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bundestrojaner"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7e15 8bc5 2bdd d90403 d800 41 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7e15                 | jle                 0x17
            //   8bc5                 | mov                 eax, ebp
            //   2bdd                 | sub                 ebx, ebp
            //   d90403               | fld                 dword ptr [ebx + eax]
            //   d800                 | fadd                dword ptr [eax]
            //   41                   | inc                 ecx

        $sequence_1 = { 3bca 7e5a 8b4e10 85c9 7443 c1f803 8d542801 }
            // n = 7, score = 100
            //   3bca                 | cmp                 ecx, edx
            //   7e5a                 | jle                 0x5c
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   85c9                 | test                ecx, ecx
            //   7443                 | je                  0x45
            //   c1f803               | sar                 eax, 3
            //   8d542801             | lea                 edx, [eax + ebp + 1]

        $sequence_2 = { 33d5 89a8c4000000 33f2 89542418 8990c8000000 8bd6 }
            // n = 6, score = 100
            //   33d5                 | xor                 edx, ebp
            //   89a8c4000000         | mov                 dword ptr [eax + 0xc4], ebp
            //   33f2                 | xor                 esi, edx
            //   89542418             | mov                 dword ptr [esp + 0x18], edx
            //   8990c8000000         | mov                 dword ptr [eax + 0xc8], edx
            //   8bd6                 | mov                 edx, esi

        $sequence_3 = { 895610 89560c 895614 7415 8b44240c 3bc2 740d }
            // n = 7, score = 100
            //   895610               | mov                 dword ptr [esi + 0x10], edx
            //   89560c               | mov                 dword ptr [esi + 0xc], edx
            //   895614               | mov                 dword ptr [esi + 0x14], edx
            //   7415                 | je                  0x17
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   3bc2                 | cmp                 eax, edx
            //   740d                 | je                  0xf

        $sequence_4 = { 8b7e1b 8ac8 80e902 f6d9 1bc9 2c02 83e102 }
            // n = 7, score = 100
            //   8b7e1b               | mov                 edi, dword ptr [esi + 0x1b]
            //   8ac8                 | mov                 cl, al
            //   80e902               | sub                 cl, 2
            //   f6d9                 | neg                 cl
            //   1bc9                 | sbb                 ecx, ecx
            //   2c02                 | sub                 al, 2
            //   83e102               | and                 ecx, 2

        $sequence_5 = { 740f 6a00 6a00 6a27 8bc8 e8???????? eb02 }
            // n = 7, score = 100
            //   740f                 | je                  0x11
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a27                 | push                0x27
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   eb02                 | jmp                 4

        $sequence_6 = { 8b44243c c68424c800000002 8b4830 51 8bce e8???????? }
            // n = 6, score = 100
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x3c]
            //   c68424c800000002     | mov                 byte ptr [esp + 0xc8], 2
            //   8b4830               | mov                 ecx, dword ptr [eax + 0x30]
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_7 = { 8bcf 8b442418 8d1476 896c2460 f7d9 8bac2430010000 83e103 }
            // n = 7, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8d1476               | lea                 edx, [esi + esi*2]
            //   896c2460             | mov                 dword ptr [esp + 0x60], ebp
            //   f7d9                 | neg                 ecx
            //   8bac2430010000       | mov                 ebp, dword ptr [esp + 0x130]
            //   83e103               | and                 ecx, 3

        $sequence_8 = { 50 8986b4000000 e8???????? 83c420 b802000000 89bec0000000 89bec4000000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8986b4000000         | mov                 dword ptr [esi + 0xb4], eax
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   b802000000           | mov                 eax, 2
            //   89bec0000000         | mov                 dword ptr [esi + 0xc0], edi
            //   89bec4000000         | mov                 dword ptr [esi + 0xc4], edi

        $sequence_9 = { 50 e8???????? 8b4c2410 8b542408 51 50 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   51                   | push                ecx
            //   50                   | push                eax

    condition:
        7 of them and filesize < 729088
}