rule win_bunitu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.bunitu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.bunitu"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c70003000000 ff75f0 8f4004 ff75ec 8f4008 8bc8 }
            // n = 6, score = 1300
            //   c70003000000         | mov                 dword ptr [eax], 3
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   8f4004               | pop                 dword ptr [eax + 4]
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8f4008               | pop                 dword ptr [eax + 8]
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { ff15???????? 59 5d 5a }
            // n = 4, score = 1300
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   5d                   | pop                 ebp
            //   5a                   | pop                 edx

        $sequence_2 = { 6a00 50 ff15???????? 6a00 68e8030000 ff15???????? 33c0 }
            // n = 7, score = 1300
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   68e8030000           | push                0x3e8
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { aa 5a 5f 5e 42 5b }
            // n = 6, score = 1300
            //   aa                   | stosb               byte ptr es:[edi], al
            //   5a                   | pop                 edx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   42                   | inc                 edx
            //   5b                   | pop                 ebx

        $sequence_4 = { 6800000100 50 51 6800080000 6a00 }
            // n = 5, score = 1300
            //   6800000100           | push                0x10000
            //   50                   | push                eax
            //   51                   | push                ecx
            //   6800080000           | push                0x800
            //   6a00                 | push                0

        $sequence_5 = { 8b85d8feffff 898538fdffff 6a10 8d8d34fdffff 51 ffb528fdffff ff15???????? }
            // n = 7, score = 1300
            //   8b85d8feffff         | mov                 eax, dword ptr [ebp - 0x128]
            //   898538fdffff         | mov                 dword ptr [ebp - 0x2c8], eax
            //   6a10                 | push                0x10
            //   8d8d34fdffff         | lea                 ecx, [ebp - 0x2cc]
            //   51                   | push                ecx
            //   ffb528fdffff         | push                dword ptr [ebp - 0x2d8]
            //   ff15????????         |                     

        $sequence_6 = { 668b85dcfeffff b901190000 49 663bc1 }
            // n = 4, score = 1300
            //   668b85dcfeffff       | mov                 ax, word ptr [ebp - 0x124]
            //   b901190000           | mov                 ecx, 0x1901
            //   49                   | dec                 ecx
            //   663bc1               | cmp                 ax, cx

        $sequence_7 = { 50 53 8d85caf7ffff 50 e8???????? }
            // n = 5, score = 1300
            //   50                   | push                eax
            //   53                   | push                ebx
            //   8d85caf7ffff         | lea                 eax, [ebp - 0x836]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 837df000 7614 6a02 ff75f0 ff15???????? ff75f0 }
            // n = 6, score = 1300
            //   837df000             | cmp                 dword ptr [ebp - 0x10], 0
            //   7614                 | jbe                 0x16
            //   6a02                 | push                2
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_9 = { 8dbd58feffff b91c000000 33c0 f3aa e8???????? 8945fc }
            // n = 6, score = 1300
            //   8dbd58feffff         | lea                 edi, [ebp - 0x1a8]
            //   b91c000000           | mov                 ecx, 0x1c
            //   33c0                 | xor                 eax, eax
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

    condition:
        7 of them and filesize < 221184
}