rule win_burnbook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.burnbook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.burnbook"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7d8 418906 418bc3 83ffff 7d02 f7d8 410fafd9 }
            // n = 7, score = 200
            //   f7d8                 | dec                 eax
            //   418906               | lea                 edi, [esi + esi*2]
            //   418bc3               | dec                 eax
            //   83ffff               | shl                 edi, 4
            //   7d02                 | mov                 edx, dword ptr [ebx + 0x68]
            //   f7d8                 | dec                 eax
            //   410fafd9             | mov                 ecx, dword ptr [ebx + 0x60]

        $sequence_1 = { e8???????? 8945ef 41b881010000 488bd7 488bcb e8???????? 4885c0 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8945ef               | mov                 edx, dword ptr [esp + 0x20]
            //   41b881010000         | test                eax, eax
            //   488bd7               | jne                 0xe46
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   4885c0               | mov                 ecx, ebx

        $sequence_2 = { f30f2cc0 8801 48ffc1 4883ea01 75c9 488b459f 4c2b5028 }
            // n = 7, score = 200
            //   f30f2cc0             | jne                 0x652
            //   8801                 | inc                 ebp
            //   48ffc1               | add                 eax, eax
            //   4883ea01             | dec                 eax
            //   75c9                 | mov                 edx, ebx
            //   488b459f             | inc                 esp
            //   4c2b5028             | mov                 dword ptr [ebx + 4], eax

        $sequence_3 = { ffc1 448bd1 f7d9 8d344e 0f1f00 0fb60a 0faf08 }
            // n = 7, score = 200
            //   ffc1                 | inc                 ecx
            //   448bd1               | mov                 dword ptr [esi], eax
            //   f7d9                 | mov                 eax, dword ptr [edi + 0x180]
            //   8d344e               | add                 eax, 2
            //   0f1f00               | mov                 dword ptr [esi + 0x7c], 2
            //   0fb60a               | mov                 dword ptr [esi + 0x80], eax
            //   0faf08               | mov                 eax, dword ptr [edi + 0x180]

        $sequence_4 = { f20f1003 f20f59c6 f20f58c7 e8???????? f20f2cc0 89862c0c0000 f20f104308 }
            // n = 7, score = 200
            //   f20f1003             | dec                 ecx
            //   f20f59c6             | mov                 ecx, esi
            //   f20f58c7             | mov                 ecx, 0x61637370
            //   e8????????           |                     
            //   f20f2cc0             | mov                 ecx, 0x4d534654
            //   89862c0c0000         | mov                 dword ptr [ebp - 0x45], eax
            //   f20f104308           | je                  0x1909

        $sequence_5 = { e8???????? 85c0 7419 488b5308 8b0c3a 85c9 7407 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   7419                 | mov                 ecx, ebp
            //   488b5308             | inc                 ecx
            //   8b0c3a               | mov                 eax, 2
            //   85c9                 | dec                 ecx
            //   7407                 | mov                 ecx, esi

        $sequence_6 = { f30f2c442440 4883c304 488d7f04 8947fc 4883ee01 75dc 488b742430 }
            // n = 7, score = 200
            //   f30f2c442440         | mov                 ecx, ebx
            //   4883c304             | mov                 eax, dword ptr [edx]
            //   488d7f04             | dec                 eax
            //   8947fc               | mov                 ebx, edx
            //   4883ee01             | dec                 eax
            //   75dc                 | mov                 esi, ecx
            //   488b742430           | test                eax, eax

        $sequence_7 = { f30f7f840cf0030000 f30f5bc2 f30f7f440cf0 81fa00010000 0f8c5cffffff 0f28bc24100c0000 0f28b424200c0000 }
            // n = 7, score = 200
            //   f30f7f840cf0030000     | add    dword ptr [esp + 0x50], 8
            //   f30f5bc2             | mov                 eax, dword ptr [esp + 0x30]
            //   f30f7f440cf0         | dec                 esp
            //   81fa00010000         | add                 esp, ecx
            //   0f8c5cffffff         | cmp                 eax, 0xa
            //   0f28bc24100c0000     | je                  0xc85
            //   0f28b424200c0000     | cmp                 eax, 0xd

        $sequence_8 = { f30f114014 488bc3 4881c448010000 415f 415e 5f 5e }
            // n = 7, score = 200
            //   f30f114014           | cmp                 dword ptr [ebp + 0xc], esi
            //   488bc3               | jle                 0x11cd
            //   4881c448010000       | dec                 esp
            //   415f                 | mov                 dword ptr [esp + 0x308], esp
            //   415e                 | dec                 eax
            //   5f                   | lea                 edx, [0x7bc83e]
            //   5e                   | dec                 esp

        $sequence_9 = { e8???????? 85c0 7814 0fb6c0 488bd6 488bcd 0bf8 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7814                 | jne                 0x17f9
            //   0fb6c0               | dec                 eax
            //   488bd6               | mov                 ecx, edi
            //   488bcd               | test                eax, eax
            //   0bf8                 | je                  0x17f4

    condition:
        7 of them and filesize < 22976512
}