rule win_buterat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.buterat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.buterat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7644 8b9ea05b4100 8d8e645a4100 8b11 395508 7305 895508 }
            // n = 7, score = 100
            //   7644                 | jbe                 0x46
            //   8b9ea05b4100         | mov                 ebx, dword ptr [esi + 0x415ba0]
            //   8d8e645a4100         | lea                 ecx, [esi + 0x415a64]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   395508               | cmp                 dword ptr [ebp + 8], edx
            //   7305                 | jae                 7
            //   895508               | mov                 dword ptr [ebp + 8], edx

        $sequence_1 = { 7e27 8b04b5e8034100 66833800 7508 8bc3 eb0d 33c0 }
            // n = 7, score = 100
            //   7e27                 | jle                 0x29
            //   8b04b5e8034100       | mov                 eax, dword ptr [esi*4 + 0x4103e8]
            //   66833800             | cmp                 word ptr [eax], 0
            //   7508                 | jne                 0xa
            //   8bc3                 | mov                 eax, ebx
            //   eb0d                 | jmp                 0xf
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 85f6 7508 81ffb7000000 7514 8d8590f5ffff 50 be???????? }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   7508                 | jne                 0xa
            //   81ffb7000000         | cmp                 edi, 0xb7
            //   7514                 | jne                 0x16
            //   8d8590f5ffff         | lea                 eax, [ebp - 0xa70]
            //   50                   | push                eax
            //   be????????           |                     

        $sequence_3 = { ff15???????? 85c0 8b4d14 8901 7505 2145fc }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   7505                 | jne                 7
            //   2145fc               | and                 dword ptr [ebp - 4], eax

        $sequence_4 = { 85c0 0f849c010000 8d4dfc 51 53 68???????? e8???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f849c010000         | je                  0x1a2
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_5 = { 50 e8???????? 83c414 85c0 744e 68???????? 53 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   744e                 | je                  0x50
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_6 = { 397df4 7477 813d????????60010000 7e6b 393d???????? 7463 bb00100000 }
            // n = 7, score = 100
            //   397df4               | cmp                 dword ptr [ebp - 0xc], edi
            //   7477                 | je                  0x79
            //   813d????????60010000     |     
            //   7e6b                 | jle                 0x6d
            //   393d????????         |                     
            //   7463                 | je                  0x65
            //   bb00100000           | mov                 ebx, 0x1000

        $sequence_7 = { 8945fc 53 6800000080 53 53 ff7508 ff35???????? }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   6800000080           | push                0x80000000
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff35????????         |                     

        $sequence_8 = { 50 53 ffd7 b9???????? 8d8500f8ffff e8???????? 6a01 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   b9????????           |                     
            //   8d8500f8ffff         | lea                 eax, [ebp - 0x800]
            //   e8????????           |                     
            //   6a01                 | push                1

        $sequence_9 = { c3 55 8bec b840180000 e8???????? ff15???????? 66833d????????00 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   b840180000           | mov                 eax, 0x1840
            //   e8????????           |                     
            //   ff15????????         |                     
            //   66833d????????00     |                     

    condition:
        7 of them and filesize < 278528
}