rule win_buzus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.buzus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.buzus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85d8faffff 50 ffd6 6804010000 8d85ccfdffff ff75a0 50 }
            // n = 7, score = 100
            //   8d85d8faffff         | lea                 eax, [ebp - 0x528]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   6804010000           | push                0x104
            //   8d85ccfdffff         | lea                 eax, [ebp - 0x234]
            //   ff75a0               | push                dword ptr [ebp - 0x60]
            //   50                   | push                eax

        $sequence_1 = { 4e 46 897508 ebbd 803e2a 750b 83f801 }
            // n = 7, score = 100
            //   4e                   | dec                 esi
            //   46                   | inc                 esi
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   ebbd                 | jmp                 0xffffffbf
            //   803e2a               | cmp                 byte ptr [esi], 0x2a
            //   750b                 | jne                 0xd
            //   83f801               | cmp                 eax, 1

        $sequence_2 = { 59 7413 ff751c 68???????? ff36 56 e8???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   7413                 | je                  0x15
            //   ff751c               | push                dword ptr [ebp + 0x1c]
            //   68????????           |                     
            //   ff36                 | push                dword ptr [esi]
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_3 = { 891d???????? 68???????? ffd5 85c0 740a c705????????01000000 }
            // n = 6, score = 100
            //   891d????????         |                     
            //   68????????           |                     
            //   ffd5                 | call                ebp
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   c705????????01000000     |     

        $sequence_4 = { b8???????? ba???????? 89858cfcffff 8985a0fcffff b8???????? 57 c785fcfbffffc8c94000 }
            // n = 7, score = 100
            //   b8????????           |                     
            //   ba????????           |                     
            //   89858cfcffff         | mov                 dword ptr [ebp - 0x374], eax
            //   8985a0fcffff         | mov                 dword ptr [ebp - 0x360], eax
            //   b8????????           |                     
            //   57                   | push                edi
            //   c785fcfbffffc8c94000     | mov    dword ptr [ebp - 0x404], 0x40c9c8

        $sequence_5 = { 8b742410 33db 33ed 3bf3 7e58 }
            // n = 5, score = 100
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   33db                 | xor                 ebx, ebx
            //   33ed                 | xor                 ebp, ebp
            //   3bf3                 | cmp                 esi, ebx
            //   7e58                 | jle                 0x5a

        $sequence_6 = { 53 8d5904 57 6a00 ffd6 59 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   8d5904               | lea                 ebx, [ecx + 4]
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx

        $sequence_7 = { c78574feffffa8cf4000 c78578feffff9ccf4000 c7857cfeffff90cf4000 c78580feffff84cf4000 c78584feffff54cf4000 c78588feffff44cf4000 c7858cfeffff2ccf4000 }
            // n = 7, score = 100
            //   c78574feffffa8cf4000     | mov    dword ptr [ebp - 0x18c], 0x40cfa8
            //   c78578feffff9ccf4000     | mov    dword ptr [ebp - 0x188], 0x40cf9c
            //   c7857cfeffff90cf4000     | mov    dword ptr [ebp - 0x184], 0x40cf90
            //   c78580feffff84cf4000     | mov    dword ptr [ebp - 0x180], 0x40cf84
            //   c78584feffff54cf4000     | mov    dword ptr [ebp - 0x17c], 0x40cf54
            //   c78588feffff44cf4000     | mov    dword ptr [ebp - 0x178], 0x40cf44
            //   c7858cfeffff2ccf4000     | mov    dword ptr [ebp - 0x174], 0x40cf2c

        $sequence_8 = { 44 1573d2446b 68ded17fda ca426b 68dddb1ffb 06 9f }
            // n = 7, score = 100
            //   44                   | inc                 esp
            //   1573d2446b           | adc                 eax, 0x6b44d273
            //   68ded17fda           | push                0xda7fd1de
            //   ca426b               | retf                0x6b42
            //   68dddb1ffb           | push                0xfb1fdbdd
            //   06                   | push                es
            //   9f                   | lahf                

        $sequence_9 = { 5f c9 c3 e8???????? 68a5040000 ff15???????? ebee }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   e8????????           |                     
            //   68a5040000           | push                0x4a5
            //   ff15????????         |                     
            //   ebee                 | jmp                 0xfffffff0

    condition:
        7 of them and filesize < 679936
}