rule win_cactus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cactus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cactus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 0f843e010000 488d1592b52000 4889d9 e8???????? 85c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   0f843e010000         | lea                 eax, [0x3be511]
            //   488d1592b52000       | mov                 edx, 0x54b
            //   4889d9               | dec                 ebp
            //   e8????????           |                     
            //   85c0                 | test                ecx, ecx

        $sequence_1 = { e8???????? e8???????? 4c8d05d3572000 baf10c0000 488d0d7f562000 e8???????? 4531c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   4c8d05d3572000       | dec                 eax
            //   baf10c0000           | mov                 ecx, dword ptr [ecx + 0x50]
            //   488d0d7f562000       | dec                 eax
            //   e8????????           |                     
            //   4531c0               | mov                 edi, eax

        $sequence_2 = { ffd7 8b18 4180fd01 76e1 4584f6 759b e8???????? }
            // n = 7, score = 100
            //   ffd7                 | dec                 eax
            //   8b18                 | lea                 edx, [ecx + 0x20]
            //   4180fd01             | push                esi
            //   76e1                 | push                ebx
            //   4584f6               | dec                 eax
            //   759b                 | sub                 esp, 0x48
            //   e8????????           |                     

        $sequence_3 = { e8???????? 4531c0 ba00010c00 b90d000000 e8???????? 4889e9 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4531c0               | dec                 ebp
            //   ba00010c00           | mov                 ecx, esp
            //   b90d000000           | dec                 eax
            //   e8????????           |                     
            //   4889e9               | mov                 dword ptr [esp + 0x38], eax
            //   e8????????           |                     

        $sequence_4 = { e8???????? 4889c1 e8???????? 488b4b30 4889c2 488b4328 488b4078 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889c1               | mov                 edx, dword ptr [esi + 0x38]
            //   e8????????           |                     
            //   488b4b30             | mov                 ecx, dword ptr [esi + 0x28]
            //   4889c2               | dec                 ebp
            //   488b4328             | test                eax, eax
            //   488b4078             | jne                 0x1154

        $sequence_5 = { eb99 c744243806000000 6690 f6431830 0f85cffdffff 488d35df063a00 e9???????? }
            // n = 7, score = 100
            //   eb99                 | mov                 edi, ecx
            //   c744243806000000     | dec                 eax
            //   6690                 | test                ebx, ebx
            //   f6431830             | je                  0x1a3
            //   0f85cffdffff         | dec                 eax
            //   488d35df063a00       | mov                 eax, ebx
            //   e9????????           |                     

        $sequence_6 = { e9???????? e8???????? 4c8d056ab43a00 bad6000000 4889e9 e8???????? 4531c0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   e8????????           |                     
            //   4c8d056ab43a00       | dec                 eax
            //   bad6000000           | sub                 esp, 0x38
            //   4889e9               | dec                 eax
            //   e8????????           |                     
            //   4531c0               | mov                 ebx, eax

        $sequence_7 = { e8???????? 488b4b10 e8???????? 85c0 0f85b4000000 488b8b90000000 bf01000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b4b10             | lea                 ecx, [0x212208]
            //   e8????????           |                     
            //   85c0                 | inc                 ebp
            //   0f85b4000000         | xor                 eax, eax
            //   488b8b90000000       | mov                 edx, 0x66
            //   bf01000000           | mov                 ecx, 0x28

        $sequence_8 = { e8???????? 4989d8 4889fa 4889f1 e8???????? 488d542423 4989d8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4989d8               | dec                 eax
            //   4889fa               | add                 esp, 0x28
            //   4889f1               | dec                 esp
            //   e8????????           |                     
            //   488d542423           | lea                 eax, [0x1a2dc0]
            //   4989d8               | mov                 edx, 0x4c

        $sequence_9 = { bacb010000 488d0d282d3b00 e8???????? 4531c0 ba00010c00 b939000000 e8???????? }
            // n = 7, score = 100
            //   bacb010000           | xor                 ecx, edi
            //   488d0d282d3b00       | dec                 esp
            //   e8????????           |                     
            //   4531c0               | add                 ebp, esi
            //   ba00010c00           | dec                 esp
            //   b939000000           | add                 ebx, eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 13587456
}