rule win_caddywiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.caddywiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.caddywiper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c645af55 c645b073 c645b165 c645b272 c645b373 c645b400 }
            // n = 6, score = 100
            //   c645af55             | mov                 byte ptr [ebp - 0x51], 0x55
            //   c645b073             | mov                 byte ptr [ebp - 0x50], 0x73
            //   c645b165             | mov                 byte ptr [ebp - 0x4f], 0x65
            //   c645b272             | mov                 byte ptr [ebp - 0x4e], 0x72
            //   c645b373             | mov                 byte ptr [ebp - 0x4d], 0x73
            //   c645b400             | mov                 byte ptr [ebp - 0x4c], 0

        $sequence_1 = { 33c0 eb69 c78564ffffff01000000 8b55a8 899568ffffff }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   eb69                 | jmp                 0x6b
            //   c78564ffffff01000000     | mov    dword ptr [ebp - 0x9c], 1
            //   8b55a8               | mov                 edx, dword ptr [ebp - 0x58]
            //   899568ffffff         | mov                 dword ptr [ebp - 0x98], edx

        $sequence_2 = { c685b6fbffff65 c685b7fbffff00 c685b8fbffff72 c685b9fbffff00 c685bafbffff6e c685bbfbffff00 }
            // n = 6, score = 100
            //   c685b6fbffff65       | mov                 byte ptr [ebp - 0x44a], 0x65
            //   c685b7fbffff00       | mov                 byte ptr [ebp - 0x449], 0
            //   c685b8fbffff72       | mov                 byte ptr [ebp - 0x448], 0x72
            //   c685b9fbffff00       | mov                 byte ptr [ebp - 0x447], 0
            //   c685bafbffff6e       | mov                 byte ptr [ebp - 0x446], 0x6e
            //   c685bbfbffff00       | mov                 byte ptr [ebp - 0x445], 0

        $sequence_3 = { 33c0 eb13 ff55b4 3d14050000 7504 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   eb13                 | jmp                 0x15
            //   ff55b4               | call                dword ptr [ebp - 0x4c]
            //   3d14050000           | cmp                 eax, 0x514
            //   7504                 | jne                 6

        $sequence_4 = { c68597feffff00 c68598feffff70 c68599feffff00 c6859afeffff69 c6859bfeffff00 c6859cfeffff33 }
            // n = 6, score = 100
            //   c68597feffff00       | mov                 byte ptr [ebp - 0x169], 0
            //   c68598feffff70       | mov                 byte ptr [ebp - 0x168], 0x70
            //   c68599feffff00       | mov                 byte ptr [ebp - 0x167], 0
            //   c6859afeffff69       | mov                 byte ptr [ebp - 0x166], 0x69
            //   c6859bfeffff00       | mov                 byte ptr [ebp - 0x165], 0
            //   c6859cfeffff33       | mov                 byte ptr [ebp - 0x164], 0x33

        $sequence_5 = { 0f85fe000000 8b55f4 8b4210 8945f0 }
            // n = 4, score = 100
            //   0f85fe000000         | jne                 0x104
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b4210               | mov                 eax, dword ptr [edx + 0x10]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_6 = { c685b8feffff72 c685b9feffff69 c685bafeffff74 c685bbfeffff79 c685bcfeffff49 }
            // n = 5, score = 100
            //   c685b8feffff72       | mov                 byte ptr [ebp - 0x148], 0x72
            //   c685b9feffff69       | mov                 byte ptr [ebp - 0x147], 0x69
            //   c685bafeffff74       | mov                 byte ptr [ebp - 0x146], 0x74
            //   c685bbfeffff79       | mov                 byte ptr [ebp - 0x145], 0x79
            //   c685bcfeffff49       | mov                 byte ptr [ebp - 0x144], 0x49

        $sequence_7 = { 85d2 7421 8b4508 0345f4 8a4dfb }
            // n = 5, score = 100
            //   85d2                 | test                edx, edx
            //   7421                 | je                  0x23
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0345f4               | add                 eax, dword ptr [ebp - 0xc]
            //   8a4dfb               | mov                 cl, byte ptr [ebp - 5]

        $sequence_8 = { c745fc00000000 c68538ffffff43 c68539ffffff6c c6853affffff6f c6853bffffff73 }
            // n = 5, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c68538ffffff43       | mov                 byte ptr [ebp - 0xc8], 0x43
            //   c68539ffffff6c       | mov                 byte ptr [ebp - 0xc7], 0x6c
            //   c6853affffff6f       | mov                 byte ptr [ebp - 0xc6], 0x6f
            //   c6853bffffff73       | mov                 byte ptr [ebp - 0xc5], 0x73

        $sequence_9 = { 83ec70 c745f800000000 c745ec00000000 64a130000000 }
            // n = 4, score = 100
            //   83ec70               | sub                 esp, 0x70
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c745ec00000000       | mov                 dword ptr [ebp - 0x14], 0
            //   64a130000000         | mov                 eax, dword ptr fs:[0x30]

    condition:
        7 of them and filesize < 33792
}