rule win_cadelspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cadelspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cadelspy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3d01010000 7d0d 8a4c181c 888840360110 40 ebe9 }
            // n = 6, score = 100
            //   3d01010000           | cmp                 eax, 0x101
            //   7d0d                 | jge                 0xf
            //   8a4c181c             | mov                 cl, byte ptr [eax + ebx + 0x1c]
            //   888840360110         | mov                 byte ptr [eax + 0x10013640], cl
            //   40                   | inc                 eax
            //   ebe9                 | jmp                 0xffffffeb

        $sequence_1 = { 7413 50 8b44241c 56 e8???????? 8bf8 59 }
            // n = 7, score = 100
            //   7413                 | je                  0x15
            //   50                   | push                eax
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   59                   | pop                 ecx

        $sequence_2 = { 89742424 e8???????? 33c0 bf06020000 57 6689842484040000 8d842486040000 }
            // n = 7, score = 100
            //   89742424             | mov                 dword ptr [esp + 0x24], esi
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   bf06020000           | mov                 edi, 0x206
            //   57                   | push                edi
            //   6689842484040000     | mov                 word ptr [esp + 0x484], ax
            //   8d842486040000       | lea                 eax, [esp + 0x486]

        $sequence_3 = { 8d9c2464020000 e8???????? 68???????? 8d9c2464020000 e8???????? }
            // n = 5, score = 100
            //   8d9c2464020000       | lea                 ebx, [esp + 0x264]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d9c2464020000       | lea                 ebx, [esp + 0x264]
            //   e8????????           |                     

        $sequence_4 = { 8d859e000000 50 e8???????? 83c40c 56 8d859c000000 50 }
            // n = 7, score = 100
            //   8d859e000000         | lea                 eax, [ebp + 0x9e]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi
            //   8d859c000000         | lea                 eax, [ebp + 0x9c]
            //   50                   | push                eax

        $sequence_5 = { 89742424 89742428 8974242c 89742430 89742434 89742438 e8???????? }
            // n = 7, score = 100
            //   89742424             | mov                 dword ptr [esp + 0x24], esi
            //   89742428             | mov                 dword ptr [esp + 0x28], esi
            //   8974242c             | mov                 dword ptr [esp + 0x2c], esi
            //   89742430             | mov                 dword ptr [esp + 0x30], esi
            //   89742434             | mov                 dword ptr [esp + 0x34], esi
            //   89742438             | mov                 dword ptr [esp + 0x38], esi
            //   e8????????           |                     

        $sequence_6 = { 56 57 33ff 8db7b03e0110 ff36 e8???????? }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   8db7b03e0110         | lea                 esi, [edi + 0x10013eb0]
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     

        $sequence_7 = { ff742414 ffd3 8bc6 e8???????? 33c0 40 eb02 }
            // n = 7, score = 100
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   ffd3                 | call                ebx
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   eb02                 | jmp                 4

        $sequence_8 = { 40 8b8d94260000 5f 5e 33cd 5b e8???????? }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   8b8d94260000         | mov                 ecx, dword ptr [ebp + 0x2694]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33cd                 | xor                 ecx, ebp
            //   5b                   | pop                 ebx
            //   e8????????           |                     

        $sequence_9 = { 39742414 0f84d3000000 397508 7474 8b4508 }
            // n = 5, score = 100
            //   39742414             | cmp                 dword ptr [esp + 0x14], esi
            //   0f84d3000000         | je                  0xd9
            //   397508               | cmp                 dword ptr [ebp + 8], esi
            //   7474                 | je                  0x76
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 204800
}