rule win_calmthorn_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.calmthorn."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.calmthorn"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb1e 8b95e42fffff 83c201 8b85e82fffff 83d000 8995e42fffff 8985e82fffff }
            // n = 7, score = 100
            //   eb1e                 | jmp                 0x20
            //   8b95e42fffff         | mov                 edx, dword ptr [ebp - 0xd01c]
            //   83c201               | add                 edx, 1
            //   8b85e82fffff         | mov                 eax, dword ptr [ebp - 0xd018]
            //   83d000               | adc                 eax, 0
            //   8995e42fffff         | mov                 dword ptr [ebp - 0xd01c], edx
            //   8985e82fffff         | mov                 dword ptr [ebp - 0xd018], eax

        $sequence_1 = { ebba 0fb68d2cfdffff 83f901 7552 c785a0c2ffff00000000 eb0f 8b95a0c2ffff }
            // n = 7, score = 100
            //   ebba                 | jmp                 0xffffffbc
            //   0fb68d2cfdffff       | movzx               ecx, byte ptr [ebp - 0x2d4]
            //   83f901               | cmp                 ecx, 1
            //   7552                 | jne                 0x54
            //   c785a0c2ffff00000000     | mov    dword ptr [ebp - 0x3d60], 0
            //   eb0f                 | jmp                 0x11
            //   8b95a0c2ffff         | mov                 edx, dword ptr [ebp - 0x3d60]

        $sequence_2 = { ebba 0fb695a6fdffff 83fa01 7553 0f57c0 660f13858498ffff eb1e }
            // n = 7, score = 100
            //   ebba                 | jmp                 0xffffffbc
            //   0fb695a6fdffff       | movzx               edx, byte ptr [ebp - 0x25a]
            //   83fa01               | cmp                 edx, 1
            //   7553                 | jne                 0x55
            //   0f57c0               | xorps               xmm0, xmm0
            //   660f13858498ffff     | movlpd              qword ptr [ebp - 0x677c], xmm0
            //   eb1e                 | jmp                 0x20

        $sequence_3 = { e8???????? 83c404 398524ecffff 7d20 8b85e4eeffff 83c001 8985e4eeffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   398524ecffff         | cmp                 dword ptr [ebp - 0x13dc], eax
            //   7d20                 | jge                 0x22
            //   8b85e4eeffff         | mov                 eax, dword ptr [ebp - 0x111c]
            //   83c001               | add                 eax, 1
            //   8985e4eeffff         | mov                 dword ptr [ebp - 0x111c], eax

        $sequence_4 = { ebba 0fb69568fdffff 83fa01 7552 c785e4e2ffff00000000 eb0f 8b85e4e2ffff }
            // n = 7, score = 100
            //   ebba                 | jmp                 0xffffffbc
            //   0fb69568fdffff       | movzx               edx, byte ptr [ebp - 0x298]
            //   83fa01               | cmp                 edx, 1
            //   7552                 | jne                 0x54
            //   c785e4e2ffff00000000     | mov    dword ptr [ebp - 0x1d1c], 0
            //   eb0f                 | jmp                 0x11
            //   8b85e4e2ffff         | mov                 eax, dword ptr [ebp - 0x1d1c]

        $sequence_5 = { ebba 0fb68d3ffdffff 83f901 7553 0f57c0 660f1385bc4dffff eb1e }
            // n = 7, score = 100
            //   ebba                 | jmp                 0xffffffbc
            //   0fb68d3ffdffff       | movzx               ecx, byte ptr [ebp - 0x2c1]
            //   83f901               | cmp                 ecx, 1
            //   7553                 | jne                 0x55
            //   0f57c0               | xorps               xmm0, xmm0
            //   660f1385bc4dffff     | movlpd              qword ptr [ebp - 0xb244], xmm0
            //   eb1e                 | jmp                 0x20

        $sequence_6 = { e8???????? 83c404 39855cdeffff 7d20 8b8df4f7ffff 83c101 898df4f7ffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   39855cdeffff         | cmp                 dword ptr [ebp - 0x21a4], eax
            //   7d20                 | jge                 0x22
            //   8b8df4f7ffff         | mov                 ecx, dword ptr [ebp - 0x80c]
            //   83c101               | add                 ecx, 1
            //   898df4f7ffff         | mov                 dword ptr [ebp - 0x80c], ecx

        $sequence_7 = { eb02 ebba 0fb68d16fdffff 83f901 7556 0f57c0 660f13859423ffff }
            // n = 7, score = 100
            //   eb02                 | jmp                 4
            //   ebba                 | jmp                 0xffffffbc
            //   0fb68d16fdffff       | movzx               ecx, byte ptr [ebp - 0x2ea]
            //   83f901               | cmp                 ecx, 1
            //   7556                 | jne                 0x58
            //   0f57c0               | xorps               xmm0, xmm0
            //   660f13859423ffff     | movlpd              qword ptr [ebp - 0xdc6c], xmm0

        $sequence_8 = { ebbb 0fb68d33fdffff 83f901 7552 c785fcc4ffff00000000 eb0f 8b95fcc4ffff }
            // n = 7, score = 100
            //   ebbb                 | jmp                 0xffffffbd
            //   0fb68d33fdffff       | movzx               ecx, byte ptr [ebp - 0x2cd]
            //   83f901               | cmp                 ecx, 1
            //   7552                 | jne                 0x54
            //   c785fcc4ffff00000000     | mov    dword ptr [ebp - 0x3b04], 0
            //   eb0f                 | jmp                 0x11
            //   8b95fcc4ffff         | mov                 edx, dword ptr [ebp - 0x3b04]

        $sequence_9 = { 8b8d5c1bffff 83c101 8b95601bffff 83d200 898d5c1bffff 8995601bffff 83bd601bffffff }
            // n = 7, score = 100
            //   8b8d5c1bffff         | mov                 ecx, dword ptr [ebp - 0xe4a4]
            //   83c101               | add                 ecx, 1
            //   8b95601bffff         | mov                 edx, dword ptr [ebp - 0xe4a0]
            //   83d200               | adc                 edx, 0
            //   898d5c1bffff         | mov                 dword ptr [ebp - 0xe4a4], ecx
            //   8995601bffff         | mov                 dword ptr [ebp - 0xe4a0], edx
            //   83bd601bffffff       | cmp                 dword ptr [ebp - 0xe4a0], -1

    condition:
        7 of them and filesize < 2322432
}