rule win_cameleon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cameleon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cameleon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7de0 85f6 0f8567ffffff 83ff20 0f83a8000000 83c8ff 2bc7 }
            // n = 7, score = 100
            //   8b7de0               | mov                 edi, dword ptr [ebp - 0x20]
            //   85f6                 | test                esi, esi
            //   0f8567ffffff         | jne                 0xffffff6d
            //   83ff20               | cmp                 edi, 0x20
            //   0f83a8000000         | jae                 0xae
            //   83c8ff               | or                  eax, 0xffffffff
            //   2bc7                 | sub                 eax, edi

        $sequence_1 = { 3975d4 7347 52 56 8d4dc0 }
            // n = 5, score = 100
            //   3975d4               | cmp                 dword ptr [ebp - 0x2c], esi
            //   7347                 | jae                 0x49
            //   52                   | push                edx
            //   56                   | push                esi
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]

        $sequence_2 = { c3 e8???????? 85c0 0f843aa70000 c3 833d????????ff 7503 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f843aa70000         | je                  0xa740
            //   c3                   | ret                 
            //   833d????????ff       |                     
            //   7503                 | jne                 5

        $sequence_3 = { c745ecd88e0210 894df8 8945fc 64a100000000 8945e8 }
            // n = 5, score = 100
            //   c745ecd88e0210       | mov                 dword ptr [ebp - 0x14], 0x10028ed8
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_4 = { 83f924 7d10 8a80f8c70410 8807 47 }
            // n = 5, score = 100
            //   83f924               | cmp                 ecx, 0x24
            //   7d10                 | jge                 0x12
            //   8a80f8c70410         | mov                 al, byte ptr [eax + 0x1004c7f8]
            //   8807                 | mov                 byte ptr [edi], al
            //   47                   | inc                 edi

        $sequence_5 = { 8b45b8 8b11 03c6 50 56 8d450c 50 }
            // n = 7, score = 100
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   03c6                 | add                 eax, esi
            //   50                   | push                eax
            //   56                   | push                esi
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax

        $sequence_6 = { 253bffffff 33f6 3bc8 740c 8b0cb584bf0410 46 85c9 }
            // n = 7, score = 100
            //   253bffffff           | and                 eax, 0xffffff3b
            //   33f6                 | xor                 esi, esi
            //   3bc8                 | cmp                 ecx, eax
            //   740c                 | je                  0xe
            //   8b0cb584bf0410       | mov                 ecx, dword ptr [esi*4 + 0x1004bf84]
            //   46                   | inc                 esi
            //   85c9                 | test                ecx, ecx

        $sequence_7 = { 7405 e8???????? a900000080 751f d9fa 833d????????00 0f85037f0000 }
            // n = 7, score = 100
            //   7405                 | je                  7
            //   e8????????           |                     
            //   a900000080           | test                eax, 0x80000000
            //   751f                 | jne                 0x21
            //   d9fa                 | fsqrt               
            //   833d????????00       |                     
            //   0f85037f0000         | jne                 0x7f09

        $sequence_8 = { 2bc1 83f808 0f86bc000000 8d7108 83fefe }
            // n = 5, score = 100
            //   2bc1                 | sub                 eax, ecx
            //   83f808               | cmp                 eax, 8
            //   0f86bc000000         | jbe                 0xc2
            //   8d7108               | lea                 esi, [ecx + 8]
            //   83fefe               | cmp                 esi, -2

        $sequence_9 = { e8???????? 8d8d04ffffff e8???????? 8d4d8c e8???????? 8d4da4 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d8d04ffffff         | lea                 ecx, [ebp - 0xfc]
            //   e8????????           |                     
            //   8d4d8c               | lea                 ecx, [ebp - 0x74]
            //   e8????????           |                     
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]

    condition:
        7 of them and filesize < 824320
}