rule win_cargobay_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cargobay."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cargobay"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 0f0b 4883ec28 4889c8 488d0d735d0e00 48894c2420 41b900010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0f0b                 | mov                 dword ptr [ebx + 0x18], eax
            //   4883ec28             | dec                 eax
            //   4889c8               | mov                 eax, ebx
            //   488d0d735d0e00       | dec                 eax
            //   48894c2420           | add                 esp, 0x1e8
            //   41b900010000         | pop                 ebx

        $sequence_1 = { e8???????? 48894308 b801000000 ebd3 4881ec88000000 488d442428 488910 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48894308             | inc                 ebp
            //   b801000000           | xor                 edi, edi
            //   ebd3                 | dec                 ecx
            //   4881ec88000000       | cmp                 edi, 4
            //   488d442428           | je                  0x190a
            //   488910               | dec                 esp

        $sequence_2 = { e8???????? 4889f1 89c2 4883c420 5e e9???????? 56 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889f1               | mov                 ecx, esi
            //   89c2                 | dec                 eax
            //   4883c420             | mov                 edx, esi
            //   5e                   | dec                 eax
            //   e9????????           |                     
            //   56                   | lea                 ecx, [esp + 0x70]

        $sequence_3 = { e8???????? 488d9424a0000000 440f294a10 440f2902 4c8db424e0000000 4c89f1 4989f8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d9424a0000000     | lea                 ecx, [ebx + 0xdd0]
            //   440f294a10           | dec                 eax
            //   440f2902             | mov                 ecx, dword ptr [ebx + 0x2e0]
            //   4c8db424e0000000     | dec                 eax
            //   4c89f1               | mov                 edx, dword ptr [ebx + 0x2e8]
            //   4989f8               | dec                 eax

        $sequence_4 = { e9???????? 89f9 4429e1 488b742430 8d5601 4585e4 410f94c0 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   89f9                 | mov                 edx, dword ptr [esp + 0x30]
            //   4429e1               | dec                 eax
            //   488b742430           | inc                 edx
            //   8d5601               | dec                 eax
            //   4585e4               | mov                 edx, dword ptr [esp + 0x30]
            //   410f94c0             | dec                 eax

        $sequence_5 = { 4c8ba424c8000000 4889f1 e8???????? 4885c0 7446 4989d0 4c89f1 }
            // n = 7, score = 100
            //   4c8ba424c8000000     | dec                 eax
            //   4889f1               | mov                 dword ptr [esp + 0x80], eax
            //   e8????????           |                     
            //   4885c0               | movups              xmm0, xmmword ptr [esp + 0x350]
            //   7446                 | movaps              xmmword ptr [esp + 0x70], xmm0
            //   4989d0               | dec                 esp
            //   4c89f1               | mov                 dword ptr [esp + 0x88], esp

        $sequence_6 = { eb0d 488908 e9???????? 440fb76734 4929d4 488d7738 31ed }
            // n = 7, score = 100
            //   eb0d                 | dec                 ebp
            //   488908               | mov                 eax, ebp
            //   e9????????           |                     
            //   440fb76734           | dec                 ecx
            //   4929d4               | inc                 eax
            //   488d7738             | je                  0x99b
            //   31ed                 | dec                 ecx

        $sequence_7 = { 49c1e104 31c0 4939c1 740b 41833c0000 488d4010 74f0 }
            // n = 7, score = 100
            //   49c1e104             | mov                 eax, dword ptr [esp + 0x10]
            //   31c0                 | dec                 eax
            //   4939c1               | mov                 ecx, ebx
            //   740b                 | dec                 eax
            //   41833c0000           | mov                 edx, dword ptr [esi]
            //   488d4010             | dec                 esp
            //   74f0                 | mov                 eax, dword ptr [esi + 8]

        $sequence_8 = { c6455e00 4c8d05ed010900 4889e9 488d5548 e8???????? 31ff 4885f6 }
            // n = 7, score = 100
            //   c6455e00             | add                 esp, 0x38
            //   4c8d05ed010900       | pop                 ebx
            //   4889e9               | pop                 edi
            //   488d5548             | ret                 
            //   e8????????           |                     
            //   31ff                 | dec                 eax
            //   4885f6               | lea                 ecx, [ebp - 0x28]

        $sequence_9 = { e8???????? 4889e9 4c89ea e8???????? e9???????? 488d1512bb1200 488dbc24f0020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889e9               | dec                 eax
            //   4c89ea               | mov                 edx, esi
            //   e8????????           |                     
            //   e9????????           |                     
            //   488d1512bb1200       | dec                 ecx
            //   488dbc24f0020000     | mov                 eax, ebx

    condition:
        7 of them and filesize < 3432448
}