rule win_carrotbat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.carrotbat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.carrotbat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff742424 c22800 c744241402000000 66f7d7 9c 89742414 0fcf }
            // n = 7, score = 100
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   c22800               | ret                 0x28
            //   c744241402000000     | mov                 dword ptr [esp + 0x14], 2
            //   66f7d7               | not                 di
            //   9c                   | pushfd              
            //   89742414             | mov                 dword ptr [esp + 0x14], esi
            //   0fcf                 | bswap               edi

        $sequence_1 = { 0f84b9000000 8975e0 8b04bd20ee4000 0500080000 3bf0 0f8396000000 }
            // n = 6, score = 100
            //   0f84b9000000         | je                  0xbf
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8b04bd20ee4000       | mov                 eax, dword ptr [edi*4 + 0x40ee20]
            //   0500080000           | add                 eax, 0x800
            //   3bf0                 | cmp                 esi, eax
            //   0f8396000000         | jae                 0x9c

        $sequence_2 = { 0f88d7feffff d2df 660fa5cf 5f 660fbaf30b 6681c61cd0 6681cef437 }
            // n = 7, score = 100
            //   0f88d7feffff         | js                  0xfffffedd
            //   d2df                 | rcr                 bh, cl
            //   660fa5cf             | shld                di, cx, cl
            //   5f                   | pop                 edi
            //   660fbaf30b           | btr                 bx, 0xb
            //   6681c61cd0           | add                 si, 0xd01c
            //   6681cef437           | or                  si, 0x37f4

        $sequence_3 = { e8???????? 33cd ff3424 0fbed9 8b5c240c 9c c60424ba }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33cd                 | xor                 ecx, ebp
            //   ff3424               | push                dword ptr [esp]
            //   0fbed9               | movsx               ebx, cl
            //   8b5c240c             | mov                 ebx, dword ptr [esp + 0xc]
            //   9c                   | pushfd              
            //   c60424ba             | mov                 byte ptr [esp], 0xba

        $sequence_4 = { 8bff 56 57 33f6 bf???????? 833cf5a4d5400001 }
            // n = 6, score = 100
            //   8bff                 | mov                 edi, edi
            //   56                   | push                esi
            //   57                   | push                edi
            //   33f6                 | xor                 esi, esi
            //   bf????????           |                     
            //   833cf5a4d5400001     | cmp                 dword ptr [esi*8 + 0x40d5a4], 1

        $sequence_5 = { 7353 8bc1 c1f805 8bf1 83e61f 8d3c8520ee4000 }
            // n = 6, score = 100
            //   7353                 | jae                 0x55
            //   8bc1                 | mov                 eax, ecx
            //   c1f805               | sar                 eax, 5
            //   8bf1                 | mov                 esi, ecx
            //   83e61f               | and                 esi, 0x1f
            //   8d3c8520ee4000       | lea                 edi, [eax*4 + 0x40ee20]

        $sequence_6 = { 7524 a1???????? a3???????? a1???????? c705????????46444000 8935???????? a3???????? }
            // n = 7, score = 100
            //   7524                 | jne                 0x26
            //   a1????????           |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????46444000     |     
            //   8935????????         |                     
            //   a3????????           |                     

        $sequence_7 = { 80e17f 3008 8b06 8bc8 c1f905 8b0c8d20ee4000 83e01f }
            // n = 7, score = 100
            //   80e17f               | and                 cl, 0x7f
            //   3008                 | xor                 byte ptr [eax], cl
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d20ee4000       | mov                 ecx, dword ptr [ecx*4 + 0x40ee20]
            //   83e01f               | and                 eax, 0x1f

        $sequence_8 = { 3b0d???????? 7353 8bc1 c1f805 8bf1 83e61f 8d3c8520ee4000 }
            // n = 7, score = 100
            //   3b0d????????         |                     
            //   7353                 | jae                 0x55
            //   8bc1                 | mov                 eax, ecx
            //   c1f805               | sar                 eax, 5
            //   8bf1                 | mov                 esi, ecx
            //   83e61f               | and                 esi, 0x1f
            //   8d3c8520ee4000       | lea                 edi, [eax*4 + 0x40ee20]

        $sequence_9 = { 5f 03d1 5e c6840201ed400000 5b 5d }
            // n = 6, score = 100
            //   5f                   | pop                 edi
            //   03d1                 | add                 edx, ecx
            //   5e                   | pop                 esi
            //   c6840201ed400000     | mov                 byte ptr [edx + eax + 0x40ed01], 0
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 360448
}