rule win_catb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.catb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.catb"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8491000000 498bc5 4c8d0d5d58ffff 83e03f 498bd5 }
            // n = 5, score = 100
            //   0f8491000000         | dec                 eax
            //   498bc5               | lea                 edx, [0x7e18]
            //   4c8d0d5d58ffff       | mov                 ecx, 0x14
            //   83e03f               | dec                 esp
            //   498bd5               | lea                 eax, [0x3a31e]

        $sequence_1 = { eb1f be07000000 488d15ef9e0000 448bc6 488bcf e8???????? 85c0 }
            // n = 7, score = 100
            //   eb1f                 | dec                 eax
            //   be07000000           | lea                 ecx, [ecx + ecx*8]
            //   488d15ef9e0000       | dec                 eax
            //   448bc6               | lea                 edx, [eax + ecx*8]
            //   488bcf               | jmp                 0x21e
            //   e8????????           |                     
            //   85c0                 | dec                 eax

        $sequence_2 = { 488d1db6a90300 488d3537fe0000 48895c2420 488d05aba90300 483bd8 7419 483933 }
            // n = 7, score = 100
            //   488d1db6a90300       | nop                 dword ptr [eax + eax]
            //   488d3537fe0000       | dec                 eax
            //   48895c2420           | lea                 edx, [ebp - 0x54]
            //   488d05aba90300       | dec                 eax
            //   483bd8               | mov                 eax, esi
            //   7419                 | nop                 word ptr [eax + eax]
            //   483933               | movzx               ecx, word ptr [edx + eax*2]

        $sequence_3 = { 4c8d0da47f0000 b903000000 4c8d05907f0000 488d15f9750000 e8???????? 4885c0 740f }
            // n = 7, score = 100
            //   4c8d0da47f0000       | mov                 eax, ebp
            //   b903000000           | dec                 eax
            //   4c8d05907f0000       | lea                 ecx, [0x399c3]
            //   488d15f9750000       | and                 eax, 0x3f
            //   e8????????           |                     
            //   4885c0               | inc                 ecx
            //   740f                 | push                edi

        $sequence_4 = { 48895c2408 4889742410 57 4883ec20 418bf0 4c8d0d8fcf0000 }
            // n = 6, score = 100
            //   48895c2408           | dec                 ecx
            //   4889742410           | or                  esi, 0xffffffff
            //   57                   | dec                 ecx
            //   4883ec20             | cmp                 eax, esi
            //   418bf0               | dec                 ecx
            //   4c8d0d8fcf0000       | mov                 ebp, eax

        $sequence_5 = { 7832 3b0d???????? 732a 4863c9 4c8d05e89f0300 488bc1 }
            // n = 6, score = 100
            //   7832                 | lea                 eax, [esi + 3]
            //   3b0d????????         |                     
            //   732a                 | dec                 eax
            //   4863c9               | test                eax, eax
            //   4c8d05e89f0300       | je                  0x3e6
            //   488bc1               | dec                 eax

        $sequence_6 = { 4c8d0d757d0000 488bd9 488d156b7d0000 b916000000 4c8d05577d0000 e8???????? 488bcb }
            // n = 7, score = 100
            //   4c8d0d757d0000       | dec                 eax
            //   488bd9               | sub                 esp, 0x20
            //   488d156b7d0000       | dec                 esp
            //   b916000000           | mov                 esi, ecx
            //   4c8d05577d0000       | dec                 eax
            //   e8????????           |                     
            //   488bcb               | test                ecx, ecx

        $sequence_7 = { 4c8d05117f0000 488d1592750000 e8???????? 8bcb }
            // n = 4, score = 100
            //   4c8d05117f0000       | dec                 eax
            //   488d1592750000       | mov                 dword ptr [esp + 0x20], eax
            //   e8????????           |                     
            //   8bcb                 | dec                 eax

        $sequence_8 = { 488bf8 4885c0 0f8483000000 41b812000000 488d1569550100 488bc8 ff15???????? }
            // n = 7, score = 100
            //   488bf8               | jmp                 0x1cc
            //   4885c0               | dec                 eax
            //   0f8483000000         | add                 eax, 0x24
            //   41b812000000         | dec                 eax
            //   488d1569550100       | test                eax, eax
            //   488bc8               | jne                 0x1da
            //   ff15????????         |                     

        $sequence_9 = { 44895c2448 81fae9fd0000 0f8570010000 4c8d3d23aaffff 418bd3 }
            // n = 5, score = 100
            //   44895c2448           | mov                 esi, ebx
            //   81fae9fd0000         | dec                 ebx
            //   0f8570010000         | lea                 eax, [ecx + esi*8]
            //   4c8d3d23aaffff       | inc                 esp
            //   418bd3               | cmp                 byte ptr [eax + esi + 0x3e], bl

    condition:
        7 of them and filesize < 593920
}