rule win_catchamas_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.catchamas."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.catchamas"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 84c9 75f1 833d????????ff 740c 8db42470100000 }
            // n = 5, score = 200
            //   84c9                 | test                cl, cl
            //   75f1                 | jne                 0xfffffff3
            //   833d????????ff       |                     
            //   740c                 | je                  0xe
            //   8db42470100000       | lea                 esi, [esp + 0x1070]

        $sequence_1 = { 40 e8???????? 85db 7411 }
            // n = 4, score = 200
            //   40                   | inc                 eax
            //   e8????????           |                     
            //   85db                 | test                ebx, ebx
            //   7411                 | je                  0x13

        $sequence_2 = { 8bf1 897c2418 c644241c00 e8???????? 68???????? }
            // n = 5, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   897c2418             | mov                 dword ptr [esp + 0x18], edi
            //   c644241c00           | mov                 byte ptr [esp + 0x1c], 0
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_3 = { 83d200 8955d0 7554 83f8ff }
            // n = 4, score = 200
            //   83d200               | adc                 edx, 0
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   7554                 | jne                 0x56
            //   83f8ff               | cmp                 eax, -1

        $sequence_4 = { 6a14 81e300800000 ffd7 83e001 33c9 8bff baba000000 }
            // n = 7, score = 200
            //   6a14                 | push                0x14
            //   81e300800000         | and                 ebx, 0x8000
            //   ffd7                 | call                edi
            //   83e001               | and                 eax, 1
            //   33c9                 | xor                 ecx, ecx
            //   8bff                 | mov                 edi, edi
            //   baba000000           | mov                 edx, 0xba

        $sequence_5 = { ff15???????? 56 8be8 55 53 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   56                   | push                esi
            //   8be8                 | mov                 ebp, eax
            //   55                   | push                ebp
            //   53                   | push                ebx

        $sequence_6 = { 6a00 52 c745dc00000000 e8???????? 8b45dc 6a00 8d4de8 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   52                   | push                edx
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0
            //   e8????????           |                     
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   6a00                 | push                0
            //   8d4de8               | lea                 ecx, [ebp - 0x18]

        $sequence_7 = { 8b45e0 7409 e8???????? 8bfc eb32 83c9ff }
            // n = 6, score = 200
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   7409                 | je                  0xb
            //   e8????????           |                     
            //   8bfc                 | mov                 edi, esp
            //   eb32                 | jmp                 0x34
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_8 = { 66894e14 5e 8b8c2404080000 33cc e8???????? }
            // n = 5, score = 200
            //   66894e14             | mov                 word ptr [esi + 0x14], cx
            //   5e                   | pop                 esi
            //   8b8c2404080000       | mov                 ecx, dword ptr [esp + 0x804]
            //   33cc                 | xor                 ecx, esp
            //   e8????????           |                     

        $sequence_9 = { e8???????? 682000cc00 53 53 56 57 55 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   682000cc00           | push                0xcc0020
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 368640
}