rule win_ceeloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ceeloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ceeloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0bd3 3bce 8bf5 23fd 0bda 8bde 0bd3 }
            // n = 7, score = 100
            //   0bd3                 | mov                 dword ptr [esp + 0x5a8], eax
            //   3bce                 | dec                 eax
            //   8bf5                 | mov                 ecx, dword ptr [esp + 0x620]
            //   23fd                 | inc                 esp
            //   0bda                 | mov                 edx, dword ptr [esp + 0x2b0]
            //   8bde                 | inc                 ecx
            //   0bd3                 | mov                 ebx, eax

        $sequence_1 = { 48c744242000000000 e8???????? 89842438020000 488b8c2440020000 e8???????? c784249402000000000000 8944243c }
            // n = 7, score = 100
            //   48c744242000000000     | lea    ecx, [esp + 0xf3c]
            //   e8????????           |                     
            //   89842438020000       | dec                 eax
            //   488b8c2440020000     | mov                 dword ptr [esp + 0x20], 0
            //   e8????????           |                     
            //   c784249402000000000000     | mov    eax, 0x4413
            //   8944243c             | and                 eax, 0x7f

        $sequence_2 = { 4883ec20 8bd9 4c8d0dc9f60700 b904000000 4c8d05b5f60700 488d15f6d80700 e8???????? }
            // n = 7, score = 100
            //   4883ec20             | imul                ebx, dword ptr [esp + 0x97c]
            //   8bd9                 | mov                 dword ptr [esp + 0xb80], ebx
            //   4c8d0dc9f60700       | mov                 ebx, eax
            //   b904000000           | and                 ebx, dword ptr [esp + 0xb80]
            //   4c8d05b5f60700       | mov                 dword ptr [esp + 0xb7c], ebx
            //   488d15f6d80700       | mov                 ebx, eax
            //   e8????????           |                     

        $sequence_3 = { c7842424060000043b0000 c7842420060000660d0000 c784241c060000a2780000 c784241806000079050000 c784241406000042520000 c78424100600002b350000 c784240c06000015070000 }
            // n = 7, score = 100
            //   c7842424060000043b0000     | mov    dword ptr [esp + 0x1c8], esp
            //   c7842420060000660d0000     | inc    ecx
            //   c784241c060000a2780000     | and    ebp, 0x161385d
            //   c784241806000079050000     | inc    esp
            //   c784241406000042520000     | mov    dword ptr [esp + 0x1dc], ebp
            //   c78424100600002b350000     | inc    esp
            //   c784240c06000015070000     | mov    ebp, dword ptr [esp + 0x1dc]

        $sequence_4 = { 89ca 2315???????? 8915???????? 0faf0d???????? 030d???????? 8b15???????? 448b05???????? }
            // n = 7, score = 100
            //   89ca                 | xor                 eax, 0x65
            //   2315????????         |                     
            //   8915????????         |                     
            //   0faf0d????????       |                     
            //   030d????????         |                     
            //   8b15????????         |                     
            //   448b05????????       |                     

        $sequence_5 = { 83393f 0f837c030000 31c0 89c1 b820000000 89c2 41b800100000 }
            // n = 7, score = 100
            //   83393f               | dec                 eax
            //   0f837c030000         | inc                 eax
            //   31c0                 | movdqa              xmmword ptr [esp + 0x20], xmm0
            //   89c1                 | movaps              xmm6, xmmword ptr [ebp - 0x79]
            //   b820000000           | jmp                 0xe4
            //   89c2                 | inc                 ebp
            //   41b800100000         | xor                 eax, eax

        $sequence_6 = { 89842444090000 8b842444090000 357a620000 89842488070000 c7842484070000d86c0000 c7842480070000e3710000 c784247c070000c1470000 }
            // n = 7, score = 100
            //   89842444090000       | jp                  0x12b
            //   8b842444090000       | or                  edx, ebx
            //   357a620000           | or                  eax, ebx
            //   89842488070000       | or                  ebx, edx
            //   c7842484070000d86c0000     | mov    ebx, esi
            //   c7842480070000e3710000     | or    edx, ebx
            //   c784247c070000c1470000     | cmp    ecx, esi

        $sequence_7 = { 448984242c010000 e9???????? 488b8424e8000000 488b00 8b8c24f0000000 }
            // n = 5, score = 100
            //   448984242c010000     | mov                 edx, dword ptr [esp + 0x128]
            //   e9????????           |                     
            //   488b8424e8000000     | dec                 eax
            //   488b00               | mov                 dword ptr [esp + 0xa0], ecx
            //   8b8c24f0000000       | dec                 eax

        $sequence_8 = { 89842400060000 8b8424dc0b0000 4189c1 4181e1ff010000 44898c242c0d0000 448b8c242c0d0000 41c1e106 }
            // n = 7, score = 100
            //   89842400060000       | or                  edx, ebx
            //   8b8424dc0b0000       | cmp                 ecx, esi
            //   4189c1               | and                 eax, edi
            //   4181e1ff010000       | and                 esi, ebp
            //   44898c242c0d0000     | or                  eax, edx
            //   448b8c242c0d0000     | or                  ebx, edx
            //   41c1e106             | mov                 ebx, esi

        $sequence_9 = { 898424800c0000 ff15???????? 89842488040000 8b8424780c0000 0b84247c0c0000 898424800c0000 8b8424800c0000 }
            // n = 7, score = 100
            //   898424800c0000       | or                  ebx, edx
            //   ff15????????         |                     
            //   89842488040000       | mov                 ebx, esi
            //   8b8424780c0000       | or                  edx, ebx
            //   0b84247c0c0000       | or                  edx, ebx
            //   898424800c0000       | cmp                 ecx, esi
            //   8b8424800c0000       | xor                 esi, ebp

    condition:
        7 of them and filesize < 2321408
}