rule win_chainshot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chainshot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chainshot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffc9 7433 ffc9 7438 ffc9 742b ffc9 }
            // n = 7, score = 300
            //   ffc9                 | add                 esp, 0x1c
            //   7433                 | pop                 edi
            //   ffc9                 | push                dword ptr [ebp + 0x10]
            //   7438                 | push                dword ptr [ebp + 0xc]
            //   ffc9                 | push                dword ptr [ebp + 8]
            //   742b                 | push                dword ptr [ebp - 0xc]
            //   ffc9                 | add                 esp, 0x20

        $sequence_1 = { 7427 83e803 0f844a110000 83f802 0f857b0f0000 }
            // n = 5, score = 300
            //   7427                 | mov                 word ptr [esp + 0x5ac], ax
            //   83e803               | movdqu              xmm0, xmmword ptr [esp + 0x14]
            //   0f844a110000         | mov                 dword ptr [esp + 0x14], 0x1db10100
            //   83f802               | mov                 dword ptr [esp + 0x18], 0x60001
            //   0f857b0f0000         | movdqu              xmmword ptr [esp + 0x5cc], xmm0

        $sequence_2 = { 7708 7519 66892c5e eb13 66892c5e bf7a000780 eb08 }
            // n = 7, score = 300
            //   7708                 | jmp                 0x981
            //   7519                 | dec                 esp
            //   66892c5e             | lea                 eax, [esp + 0x30]
            //   eb13                 | jne                 0x996
            //   66892c5e             | mov                 eax, dword ptr [ebp - 4]
            //   bf7a000780           | push                4
            //   eb08                 | push                0x3000

        $sequence_3 = { eb23 8b4520 8906 eb1c b90b000080 eb05 }
            // n = 6, score = 300
            //   eb23                 | mov                 ebx, eax
            //   8b4520               | test                eax, eax
            //   8906                 | js                  0x750
            //   eb1c                 | dec                 eax
            //   b90b000080           | mov                 edx, edi
            //   eb05                 | mov                 ebx, eax

        $sequence_4 = { 83c705 c7041f4c8b4424 c6441f0418 83c705 c7041f4c8b4c24 }
            // n = 5, score = 300
            //   83c705               | movzx               eax, byte ptr [ebx]
            //   c7041f4c8b4424       | inc                 eax
            //   c6441f0418           | jne                 0x14e5
            //   83c705               | movzx               ecx, byte ptr [ecx]
            //   c7041f4c8b4c24       | inc                 ecx

        $sequence_5 = { e8???????? 89442420 85c0 7826 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   89442420             | mov                 dword ptr [esp + 0x34], 0x38390001
            //   85c0                 | mov                 dword ptr [esp + 0x38], 0xa0000
            //   7826                 | mov                 dword ptr [esp + 0x3c], 0x814908

        $sequence_6 = { ffd0 8905???????? b90b000080 894c2420 e9???????? }
            // n = 5, score = 300
            //   ffd0                 | push                dword ptr [ebp - 8]
            //   8905????????         |                     
            //   b90b000080           | push                edi
            //   894c2420             | test                eax, eax
            //   e9????????           |                     

        $sequence_7 = { 747a ffc8 7461 83e802 }
            // n = 4, score = 300
            //   747a                 | sub                 eax, ebx
            //   ffc8                 | inc                 cx
            //   7461                 | mov                 dword ptr [eax + ecx*2 + 0x306b0], eax
            //   83e802               | inc                 edx

        $sequence_8 = { 7408 ffd1 8905???????? b84b000080 }
            // n = 4, score = 300
            //   7408                 | je                  0x52e
            //   ffd1                 | cmp                 dword ptr [ebp + 0xc], 0
            //   8905????????         |                     
            //   b84b000080           | push                esi

        $sequence_9 = { 0f8599000000 c705????????0b000000 e9???????? b902000000 }
            // n = 4, score = 300
            //   0f8599000000         | inc                 esp
            //   c705????????0b000000     |     
            //   e9????????           |                     
            //   b902000000           | je                  0x3a9

    condition:
        7 of them and filesize < 802816
}