rule win_chaperone_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chaperone."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chaperone"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b442458 4839442428 0f8dd0000000 0fb6442421 83c001 }
            // n = 5, score = 100
            //   488b442458           | mov                 ecx, dword ptr [esp + 0x4f0]
            //   4839442428           | dec                 eax
            //   0f8dd0000000         | lea                 edx, [esp + 0x270]
            //   0fb6442421           | dec                 eax
            //   83c001               | lea                 ecx, [esp + 0x30]

        $sequence_1 = { ff15???????? 48898424902b0000 488d742470 488bbc24902b0000 b990180000 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   48898424902b0000     | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   488d742470           | dec                 eax
            //   488bbc24902b0000     | lea                 ecx, [esp + 0x38]
            //   b990180000           | dec                 eax

        $sequence_2 = { b9ffff1f00 ff15???????? 4889842450020000 4883bc245002000000 0f842b020000 4c8d842458020000 baff010f00 }
            // n = 7, score = 100
            //   b9ffff1f00           | dec                 eax
            //   ff15????????         |                     
            //   4889842450020000     | add                 esp, 0x88
            //   4883bc245002000000     | xor    eax, eax
            //   0f842b020000         | dec                 eax
            //   4c8d842458020000     | mov                 ecx, dword ptr [esp + 0x4950]
            //   baff010f00           | dec                 eax

        $sequence_3 = { 48898424c0020000 837c243400 746b 4c8b842490000000 8b542434 488b8c24c0020000 }
            // n = 6, score = 100
            //   48898424c0020000     | lea                 edx, [esp + 0xc8]
            //   837c243400           | dec                 eax
            //   746b                 | mov                 ecx, dword ptr [esp + 0x380]
            //   4c8b842490000000     | jne                 0xbb1
            //   8b542434             | xor                 ecx, ecx
            //   488b8c24c0020000     | dec                 eax

        $sequence_4 = { 488d7c2450 488d35fba70000 b926000000 f3a4 }
            // n = 4, score = 100
            //   488d7c2450           | mov                 ecx, dword ptr [esp + 0x38]
            //   488d35fba70000       | dec                 eax
            //   b926000000           | mov                 dword ptr [esp + 0x30], eax
            //   f3a4                 | dec                 eax

        $sequence_5 = { 4889542410 48894c2408 4883ec48 488b442460 0fb68000010000 88442421 }
            // n = 6, score = 100
            //   4889542410           | dec                 eax
            //   48894c2408           | add                 ecx, 0x238
            //   4883ec48             | lea                 eax, [eax + eax + 4]
            //   488b442460           | je                  0x235
            //   0fb68000010000       | dec                 eax
            //   88442421             | mov                 ecx, dword ptr [esp + 0x20]

        $sequence_6 = { 488b0424 480590180000 48890424 ebb7 488b442420 }
            // n = 5, score = 100
            //   488b0424             | mov                 word ptr [esp + 0xb0], dx
            //   480590180000         | xor                 eax, eax
            //   48890424             | cmp                 eax, dword ptr [esp + 0x2d8]
            //   ebb7                 | jb                  0x102c
            //   488b442420           | cmp                 dword ptr [esp + 0x2dc], 0

        $sequence_7 = { 85c0 750a b801000000 e9???????? 488d442440 4889842498030000 488d842460030000 }
            // n = 7, score = 100
            //   85c0                 | lea                 ecx, [esp + 0x30]
            //   750a                 | dec                 eax
            //   b801000000           | lea                 ecx, [esp + 0x30]
            //   e9????????           |                     
            //   488d442440           | dec                 eax
            //   4889842498030000     | mov                 edx, dword ptr [esp + 0x5a8]
            //   488d842460030000     | dec                 eax

        $sequence_8 = { 4533c9 4533c0 33d2 33c9 e8???????? 488d158a090100 }
            // n = 6, score = 100
            //   4533c9               | lea                 edi, [esp + 0x210]
            //   4533c0               | dec                 eax
            //   33d2                 | lea                 esi, [0x8c31]
            //   33c9                 | mov                 ecx, 0x18
            //   e8????????           |                     
            //   488d158a090100       | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_9 = { 488bd9 448d6eff 443bd7 754f 4c8d0565ce0000 458bcd ba00010000 }
            // n = 7, score = 100
            //   488bd9               | cmp                 dword ptr [esp + 0x70], 0
            //   448d6eff             | je                  0x5e2
            //   443bd7               | dec                 esp
            //   754f                 | mov                 ecx, dword ptr [esp + 0x40]
            //   4c8d0565ce0000       | dec                 ecx
            //   458bcd               | add                 ecx, 0x230
            //   ba00010000           | dec                 eax

    condition:
        7 of them and filesize < 373760
}