rule win_cherry_picker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cherry_picker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cherry_picker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd3 68???????? 56 8944242c ffd3 68???????? }
            // n = 6, score = 300
            //   ffd3                 | call                ebx
            //   68????????           |                     
            //   56                   | push                esi
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   ffd3                 | call                ebx
            //   68????????           |                     

        $sequence_1 = { 8d442428 50 ff542420 8b442420 }
            // n = 4, score = 300
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   50                   | push                eax
            //   ff542420             | call                dword ptr [esp + 0x20]
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]

        $sequence_2 = { 8bf0 8bd1 83c408 2bf2 8a11 88140e 41 }
            // n = 7, score = 300
            //   8bf0                 | mov                 esi, eax
            //   8bd1                 | mov                 edx, ecx
            //   83c408               | add                 esp, 8
            //   2bf2                 | sub                 esi, edx
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   88140e               | mov                 byte ptr [esi + ecx], dl
            //   41                   | inc                 ecx

        $sequence_3 = { 68???????? 68???????? a3???????? ffd6 69c0e8030000 }
            // n = 5, score = 300
            //   68????????           |                     
            //   68????????           |                     
            //   a3????????           |                     
            //   ffd6                 | call                esi
            //   69c0e8030000         | imul                eax, eax, 0x3e8

        $sequence_4 = { ff15???????? a3???????? 85c0 7512 68???????? 50 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   7512                 | jne                 0x14
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_5 = { a3???????? ffd6 68???????? 6a3c }
            // n = 4, score = 300
            //   a3????????           |                     
            //   ffd6                 | call                esi
            //   68????????           |                     
            //   6a3c                 | push                0x3c

        $sequence_6 = { 8bf0 0fbec9 81e6ff000000 33f1 8a4a01 42 c1f808 }
            // n = 7, score = 300
            //   8bf0                 | mov                 esi, eax
            //   0fbec9               | movsx               ecx, cl
            //   81e6ff000000         | and                 esi, 0xff
            //   33f1                 | xor                 esi, ecx
            //   8a4a01               | mov                 cl, byte ptr [edx + 1]
            //   42                   | inc                 edx
            //   c1f808               | sar                 eax, 8

        $sequence_7 = { 68e8030000 68???????? 68???????? a3???????? }
            // n = 4, score = 300
            //   68e8030000           | push                0x3e8
            //   68????????           |                     
            //   68????????           |                     
            //   a3????????           |                     

        $sequence_8 = { 68???????? 68e8030000 68???????? 68???????? a3???????? }
            // n = 5, score = 300
            //   68????????           |                     
            //   68e8030000           | push                0x3e8
            //   68????????           |                     
            //   68????????           |                     
            //   a3????????           |                     

        $sequence_9 = { 68???????? 56 8944242c ffd3 68???????? }
            // n = 5, score = 300
            //   68????????           |                     
            //   56                   | push                esi
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   ffd3                 | call                ebx
            //   68????????           |                     

    condition:
        7 of them and filesize < 712704
}