rule win_chinotto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chinotto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chinotto"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4df0 897df4 895de4 8955f8 85c9 0f853dffffff e9???????? }
            // n = 7, score = 100
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   897df4               | mov                 dword ptr [ebp - 0xc], edi
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   85c9                 | test                ecx, ecx
            //   0f853dffffff         | jne                 0xffffff43
            //   e9????????           |                     

        $sequence_1 = { 57 33f6 bf???????? 833cf5a4e6410001 751d 8d04f5a0e64100 8938 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   33f6                 | xor                 esi, esi
            //   bf????????           |                     
            //   833cf5a4e6410001     | cmp                 dword ptr [esi*8 + 0x41e6a4], 1
            //   751d                 | jne                 0x1f
            //   8d04f5a0e64100       | lea                 eax, [esi*8 + 0x41e6a0]
            //   8938                 | mov                 dword ptr [eax], edi

        $sequence_2 = { 8985a8f6ffff 8d95b4f6ffff 52 8d85c4f6ffff 50 c785a0f6ffff0c000000 }
            // n = 6, score = 100
            //   8985a8f6ffff         | mov                 dword ptr [ebp - 0x958], eax
            //   8d95b4f6ffff         | lea                 edx, [ebp - 0x94c]
            //   52                   | push                edx
            //   8d85c4f6ffff         | lea                 eax, [ebp - 0x93c]
            //   50                   | push                eax
            //   c785a0f6ffff0c000000     | mov    dword ptr [ebp - 0x960], 0xc

        $sequence_3 = { c3 8b4d08 8b5648 8b45f4 c74638c0444000 897644 897a3c }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b5648               | mov                 edx, dword ptr [esi + 0x48]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   c74638c0444000       | mov                 dword ptr [esi + 0x38], 0x4044c0
            //   897644               | mov                 dword ptr [esi + 0x44], esi
            //   897a3c               | mov                 dword ptr [edx + 0x3c], edi

        $sequence_4 = { 5d c3 8b4de0 8b55d8 8b45ec c1e106 034ddc }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   c1e106               | shl                 ecx, 6
            //   034ddc               | add                 ecx, dword ptr [ebp - 0x24]

        $sequence_5 = { 8bd0 8955d8 eb03 8955d8 }
            // n = 4, score = 100
            //   8bd0                 | mov                 edx, eax
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx
            //   eb03                 | jmp                 5
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx

        $sequence_6 = { 50 ff15???????? 8b853cf7ffff 03c3 50 e8???????? 8b8d38f7ffff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b853cf7ffff         | mov                 eax, dword ptr [ebp - 0x8c4]
            //   03c3                 | add                 eax, ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b8d38f7ffff         | mov                 ecx, dword ptr [ebp - 0x8c8]

        $sequence_7 = { b969000000 66894de2 b96f000000 66894de4 b96e000000 66894de6 b93d000000 }
            // n = 7, score = 100
            //   b969000000           | mov                 ecx, 0x69
            //   66894de2             | mov                 word ptr [ebp - 0x1e], cx
            //   b96f000000           | mov                 ecx, 0x6f
            //   66894de4             | mov                 word ptr [ebp - 0x1c], cx
            //   b96e000000           | mov                 ecx, 0x6e
            //   66894de6             | mov                 word ptr [ebp - 0x1a], cx
            //   b93d000000           | mov                 ecx, 0x3d

        $sequence_8 = { 8b5628 6a58 6a01 51 }
            // n = 4, score = 100
            //   8b5628               | mov                 edx, dword ptr [esi + 0x28]
            //   6a58                 | push                0x58
            //   6a01                 | push                1
            //   51                   | push                ecx

        $sequence_9 = { 6683f919 7725 8d4805 83f97a 7e08 83c0eb 0fb7c0 }
            // n = 7, score = 100
            //   6683f919             | cmp                 cx, 0x19
            //   7725                 | ja                  0x27
            //   8d4805               | lea                 ecx, [eax + 5]
            //   83f97a               | cmp                 ecx, 0x7a
            //   7e08                 | jle                 0xa
            //   83c0eb               | add                 eax, -0x15
            //   0fb7c0               | movzx               eax, ax

    condition:
        7 of them and filesize < 300032
}