rule win_chir_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chir."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chir"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 c745f840214125 c745fc32212400 e8???????? }
            // n = 4, score = 300
            //   50                   | push                eax
            //   c745f840214125       | mov                 dword ptr [ebp - 8], 0x25412140
            //   c745fc32212400       | mov                 dword ptr [ebp - 4], 0x242132
            //   e8????????           |                     

        $sequence_1 = { 48 59 8bfb 7419 }
            // n = 4, score = 300
            //   48                   | dec                 eax
            //   59                   | pop                 ecx
            //   8bfb                 | mov                 edi, ebx
            //   7419                 | je                  0x1b

        $sequence_2 = { 8d45f0 50 c745f021352432 c745f451173300 e8???????? 48 }
            // n = 6, score = 300
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   c745f021352432       | mov                 dword ptr [ebp - 0x10], 0x32243521
            //   c745f451173300       | mov                 dword ptr [ebp - 0xc], 0x331751
            //   e8????????           |                     
            //   48                   | dec                 eax

        $sequence_3 = { 8d4c15f8 8a19 80f3fc 80c302 80f301 80c303 }
            // n = 6, score = 300
            //   8d4c15f8             | lea                 ecx, [ebp + edx - 8]
            //   8a19                 | mov                 bl, byte ptr [ecx]
            //   80f3fc               | xor                 bl, 0xfc
            //   80c302               | add                 bl, 2
            //   80f301               | xor                 bl, 1
            //   80c303               | add                 bl, 3

        $sequence_4 = { 8d45f4 50 c745f421352432 c745f851173300 e8???????? }
            // n = 5, score = 300
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   c745f421352432       | mov                 dword ptr [ebp - 0xc], 0x32243521
            //   c745f851173300       | mov                 dword ptr [ebp - 8], 0x331751
            //   e8????????           |                     

        $sequence_5 = { 740b 48 8906 66837c47fe5c }
            // n = 4, score = 300
            //   740b                 | je                  0xd
            //   48                   | dec                 eax
            //   8906                 | mov                 dword ptr [esi], eax
            //   66837c47fe5c         | cmp                 word ptr [edi + eax*2 - 2], 0x5c

        $sequence_6 = { c745f451173300 e8???????? 48 59 8bfb }
            // n = 5, score = 300
            //   c745f451173300       | mov                 dword ptr [ebp - 0xc], 0x331751
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   59                   | pop                 ecx
            //   8bfb                 | mov                 edi, ebx

        $sequence_7 = { 7415 8d4c15f8 8a01 34fc 0402 3401 0403 }
            // n = 7, score = 300
            //   7415                 | je                  0x17
            //   8d4c15f8             | lea                 ecx, [ebp + edx - 8]
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   34fc                 | xor                 al, 0xfc
            //   0402                 | add                 al, 2
            //   3401                 | xor                 al, 1
            //   0403                 | add                 al, 3

        $sequence_8 = { 42 8801 3bd7 72eb }
            // n = 4, score = 300
            //   42                   | inc                 edx
            //   8801                 | mov                 byte ptr [ecx], al
            //   3bd7                 | cmp                 edx, edi
            //   72eb                 | jb                  0xffffffed

        $sequence_9 = { 8d45f4 50 c745f421352432 c745f851173300 }
            // n = 4, score = 300
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   c745f421352432       | mov                 dword ptr [ebp - 0xc], 0x32243521
            //   c745f851173300       | mov                 dword ptr [ebp - 8], 0x331751

    condition:
        7 of them and filesize < 286720
}