rule win_chthonic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.chthonic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.chthonic"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bcf d3ee 83e601 eb00 8b4df8 }
            // n = 5, score = 600
            //   8bcf                 | mov                 ecx, edi
            //   d3ee                 | shr                 esi, cl
            //   83e601               | and                 esi, 1
            //   eb00                 | jmp                 2
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_1 = { 0f850d010000 8b4df0 eb00 894df8 }
            // n = 4, score = 600
            //   0f850d010000         | jne                 0x113
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   eb00                 | jmp                 2
            //   894df8               | mov                 dword ptr [ebp - 8], ecx

        $sequence_2 = { 8a08 32ca 80e17f 8808 b001 c3 8b442404 }
            // n = 7, score = 600
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   32ca                 | xor                 cl, dl
            //   80e17f               | and                 cl, 0x7f
            //   8808                 | mov                 byte ptr [eax], cl
            //   b001                 | mov                 al, 1
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]

        $sequence_3 = { 74cf 8345fc02 b9000d0000 3b4df8 1bc9 f7d9 014dfc }
            // n = 7, score = 600
            //   74cf                 | je                  0xffffffd1
            //   8345fc02             | add                 dword ptr [ebp - 4], 2
            //   b9000d0000           | mov                 ecx, 0xd00
            //   3b4df8               | cmp                 ecx, dword ptr [ebp - 8]
            //   1bc9                 | sbb                 ecx, ecx
            //   f7d9                 | neg                 ecx
            //   014dfc               | add                 dword ptr [ebp - 4], ecx

        $sequence_4 = { 894df0 e9???????? 8b4514 8b4df4 8908 33c0 3b550c }
            // n = 7, score = 600
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   e9????????           |                     
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   33c0                 | xor                 eax, eax
            //   3b550c               | cmp                 edx, dword ptr [ebp + 0xc]

        $sequence_5 = { 5f c1ee1f e9???????? 8b041a 6a1f 8bf0 }
            // n = 6, score = 600
            //   5f                   | pop                 edi
            //   c1ee1f               | shr                 esi, 0x1f
            //   e9????????           |                     
            //   8b041a               | mov                 eax, dword ptr [edx + ebx]
            //   6a1f                 | push                0x1f
            //   8bf0                 | mov                 esi, eax

        $sequence_6 = { 80e17f 8808 b001 c3 8b442404 }
            // n = 5, score = 600
            //   80e17f               | and                 cl, 0x7f
            //   8808                 | mov                 byte ptr [eax], cl
            //   b001                 | mov                 al, 1
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]

        $sequence_7 = { e9???????? 8b041a 6a1f 8bf0 83c204 5f }
            // n = 6, score = 600
            //   e9????????           |                     
            //   8b041a               | mov                 eax, dword ptr [edx + ebx]
            //   6a1f                 | push                0x1f
            //   8bf0                 | mov                 esi, eax
            //   83c204               | add                 edx, 4
            //   5f                   | pop                 edi

        $sequence_8 = { 7cf4 33f6 33d2 8bc6 f77514 8b4510 8d8cb5fcfbffff }
            // n = 7, score = 600
            //   7cf4                 | jl                  0xfffffff6
            //   33f6                 | xor                 esi, esi
            //   33d2                 | xor                 edx, edx
            //   8bc6                 | mov                 eax, esi
            //   f77514               | div                 dword ptr [ebp + 0x14]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8d8cb5fcfbffff       | lea                 ecx, [ebp + esi*4 - 0x404]

        $sequence_9 = { 3b550c 5f 5e 0f94c0 5b c9 c3 }
            // n = 7, score = 600
            //   3b550c               | cmp                 edx, dword ptr [ebp + 0xc]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   0f94c0               | sete                al
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 425984
}