rule win_cicada3301_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cicada3301."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cicada3301"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 4c8d057fb12e00 4c89d9 4c89d2 e8???????? 4c8d059db12e00 4c89d9 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d057fb12e00       | mov                 ecx, edx
            //   4c89d9               | dec                 esp
            //   4c89d2               | mov                 edx, ecx
            //   e8????????           |                     
            //   4c8d059db12e00       | dec                 esp
            //   4c89d9               | lea                 eax, [0x3a223e]

        $sequence_1 = { e8???????? 4531ff 4c89f9 4889f2 e8???????? 31db 4889d9 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4531ff               | add                 ebx, eax
            //   4c89f9               | test                cl, cl
            //   4889f2               | jne                 0x25
            //   e8????????           |                     
            //   31db                 | inc                 edx
            //   4889d9               | lea                 eax, [esi*2 + 1]

        $sequence_2 = { f30f6f00 0f104810 0f105020 660f7f842420010000 0f298c2430010000 0f29942440010000 488b542470 }
            // n = 7, score = 100
            //   f30f6f00             | divss               xmm0, xmm2
            //   0f104810             | mulss               xmm0, xmm1
            //   0f105020             | subss               xmm0, xmm6
            //   660f7f842420010000     | cmp    ecx, eax
            //   0f298c2430010000     | jge                 0x342
            //   0f29942440010000     | movd                edx, xmm0
            //   488b542470           | inc                 ecx

        $sequence_3 = { e9???????? 4885c0 0f8499070000 84db 0f85c9020000 488b9c24b0010000 4839cf }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4885c0               | dec                 eax
            //   0f8499070000         | lea                 edx, [ecx*8 + 8]
            //   84db                 | dec                 esp
            //   0f85c9020000         | add                 edx, ebp
            //   488b9c24b0010000     | dec                 ecx
            //   4839cf               | cmp                 esi, edx

        $sequence_4 = { e8???????? 49ffcf 4d897e48 4d85ed 0f84e2010000 4c896c2428 0f28442460 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   49ffcf               | dec                 ebp
            //   4d897e48             | cmp                 esi, esp
            //   4d85ed               | dec                 ecx
            //   0f84e2010000         | mov                 edi, dword ptr [esp + 0x10]
            //   4c896c2428           | dec                 esp
            //   0f28442460           | lea                 edi, [0x262710]

        $sequence_5 = { f30f6f8610020000 f30f6f8b08020000 660f70c044 660febc1 f30f7f8308020000 0f1006 0f1103 }
            // n = 7, score = 100
            //   f30f6f8610020000     | inc                 esp
            //   f30f6f8b08020000     | mov                 edi, dword ptr [esp + 0x5c]
            //   660f70c044           | mov                 ecx, dword ptr [esp + 0x60]
            //   660febc1             | dec                 eax
            //   f30f7f8308020000     | mov                 edx, dword ptr [esp + 0x64]
            //   0f1006               | movsd               xmm7, qword ptr [esp + 0x6c]
            //   0f1103               | movdqu              xmm6, xmmword ptr [esp + 0x44]

        $sequence_6 = { eb21 4889de 4c8d0531002c00 4889e9 4889f2 e8???????? e9???????? }
            // n = 7, score = 100
            //   eb21                 | je                  0xffffffe1
            //   4889de               | dec                 eax
            //   4c8d0531002c00       | bsr                 eax, eax
            //   4889e9               | dec                 eax
            //   4889f2               | xor                 eax, 0x3f
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_7 = { ff13 e9???????? 4d85f6 7433 498d4c2408 4c89f0 488b4cc1f8 }
            // n = 7, score = 100
            //   ff13                 | jne                 0x1dcc
            //   e9????????           |                     
            //   4d85f6               | test                edx, 0x20000000
            //   7433                 | je                  0xb90
            //   498d4c2408           | movzx               eax, byte ptr [eax]
            //   4c89f0               | test                edx, 0x8000000
            //   488b4cc1f8           | dec                 eax

        $sequence_8 = { e8???????? 0f108424e0000000 0f108c24f0000000 0f10942400010000 0f29442450 0f294c2460 0f29542470 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0f108424e0000000     | inc                 ecx
            //   0f108c24f0000000     | cmp                 bh, 2
            //   0f10942400010000     | dec                 eax
            //   0f29442450           | mov                 dword ptr [esp + 0x20], esi
            //   0f294c2460           | dec                 eax
            //   0f29542470           | mov                 dword ptr [esp + 0xc8], edi

        $sequence_9 = { c1eb10 488d8c2490020000 488d94248b030000 41b8f5000000 e8???????? 4c8b442440 4c8b4c2438 }
            // n = 7, score = 100
            //   c1eb10               | or                  byte ptr [edi + edx + 0x70], 0x40
            //   488d8c2490020000     | dec                 ecx
            //   488d94248b030000     | add                 ebx, 4
            //   41b8f5000000         | dec                 ebp
            //   e8????????           |                     
            //   4c8b442440           | cmp                 eax, ebx
            //   4c8b4c2438           | jne                 0x47c

    condition:
        7 of them and filesize < 11247616
}