rule win_clipog_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.clipog."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.clipog"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b4b18 6685c0 740c 488d1552e70100 }
            // n = 4, score = 100
            //   488b4b18             | dec                 eax
            //   6685c0               | mov                 eax, edx
            //   740c                 | dec                 eax
            //   488d1552e70100       | lea                 ecx, [0x14f51]

        $sequence_1 = { 488d1552e70100 e9???????? 488d154ae70100 e9???????? b910000000 }
            // n = 5, score = 100
            //   488d1552e70100       | dec                 eax
            //   e9????????           |                     
            //   488d154ae70100       | cmp                 ecx, 0x10
            //   e9????????           |                     
            //   b910000000           | jae                 0x530

        $sequence_2 = { 760c 488d0d5fec0100 e8???????? 48397b18 730d 488bd7 }
            // n = 6, score = 100
            //   760c                 | lea                 eax, [0x14cc9]
            //   488d0d5fec0100       | dec                 eax
            //   e8????????           |                     
            //   48397b18             | mov                 ecx, dword ptr [esp + 0x30]
            //   730d                 | dec                 eax
            //   488bd7               | cmp                 ecx, eax

        $sequence_3 = { 753b 488b41f8 483bc1 7338 482bc8 4883f908 7235 }
            // n = 7, score = 100
            //   753b                 | dec                 eax
            //   488b41f8             | mov                 edx, edi
            //   483bc1               | dec                 eax
            //   7338                 | lea                 ecx, [0x1afdd]
            //   482bc8               | je                  0x177
            //   4883f908             | test                eax, eax
            //   7235                 | je                  0x170

        $sequence_4 = { 4883f808 725d 48ffc0 488b4c2448 493bc4 7606 e8???????? }
            // n = 7, score = 100
            //   4883f808             | jne                 0x68a
            //   725d                 | jmp                 0x6bb
            //   48ffc0               | dec                 eax
            //   488b4c2448           | mov                 dword ptr [ebx], edi
            //   493bc4               | inc                 ecx
            //   7606                 | mov                 eax, 1
            //   e8????????           |                     

        $sequence_5 = { 488bda 4c8d0d1fbc0000 8bf9 488d1586a10000 b906000000 4c8d0502bc0000 e8???????? }
            // n = 7, score = 100
            //   488bda               | dec                 eax
            //   4c8d0d1fbc0000       | mov                 eax, ebx
            //   8bf9                 | dec                 eax
            //   488d1586a10000       | mov                 ecx, dword ptr [ebp + 0xc0]
            //   b906000000           | dec                 eax
            //   4c8d0502bc0000       | xor                 ecx, esp
            //   e8????????           |                     

        $sequence_6 = { 488b05???????? 4833c4 488985a0040000 4c8b95f8040000 488d0524160100 0f1000 }
            // n = 6, score = 100
            //   488b05????????       |                     
            //   4833c4               | dec                 eax
            //   488985a0040000       | lea                 esi, [0x1cc03]
            //   4c8b95f8040000       | dec                 eax
            //   488d0524160100       | mov                 dword ptr [esp + 8], ebx
            //   0f1000               | dec                 eax

        $sequence_7 = { 488d158ee80100 e9???????? b910000000 ff15???????? 488b4b18 }
            // n = 5, score = 100
            //   488d158ee80100       | cmp                 ecx, edx
            //   e9????????           |                     
            //   b910000000           | je                  0x732
            //   ff15????????         |                     
            //   488b4b18             | dec                 eax

        $sequence_8 = { e8???????? 90 4c8d0556ea0100 488bd0 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   90                   | jbe                 0x247
            //   4c8d0556ea0100       | nop                 
            //   488bd0               | dec                 eax

        $sequence_9 = { 488d1599100200 488d0d9a100200 e8???????? 488bd8 488d4c2430 48837c244810 480f434c2430 }
            // n = 7, score = 100
            //   488d1599100200       | mov                 esi, eax
            //   488d0d9a100200       | and                 dword ptr [edi + 4], 0
            //   e8????????           |                     
            //   488bd8               | dec                 eax
            //   488d4c2430           | mov                 eax, dword ptr [ecx + eax*8]
            //   48837c244810         | dec                 eax
            //   480f434c2430         | lea                 ecx, [0x10da1]

    condition:
        7 of them and filesize < 372736
}