rule win_clop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.clop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.clop"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a04 6800300000 6887000000 6a00 }
            // n = 4, score = 900
            //   6a04                 | push                4
            //   6800300000           | push                0x3000
            //   6887000000           | push                0x87
            //   6a00                 | push                0

        $sequence_1 = { 83c40c 6860070000 6a40 ff15???????? }
            // n = 4, score = 900
            //   83c40c               | add                 esp, 0xc
            //   6860070000           | push                0x760
            //   6a40                 | push                0x40
            //   ff15????????         |                     

        $sequence_2 = { 57 6a00 ff15???????? 68???????? 8bd8 }
            // n = 5, score = 800
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   68????????           |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_3 = { ff15???????? 8bf0 56 53 ff15???????? 50 ff15???????? }
            // n = 7, score = 800
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   56                   | push                esi
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_4 = { 50 ff15???????? 56 53 8bf8 }
            // n = 5, score = 800
            //   50                   | push                eax
            //   ff15????????         |                     
            //   56                   | push                esi
            //   53                   | push                ebx
            //   8bf8                 | mov                 edi, eax

        $sequence_5 = { 53 8bf8 ff15???????? 8bf0 56 6a40 }
            // n = 6, score = 800
            //   53                   | push                ebx
            //   8bf8                 | mov                 edi, eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   56                   | push                esi
            //   6a40                 | push                0x40

        $sequence_6 = { 668b0424 6683e07f 6683f87f 8d642408 0f85fd0b0000 eb00 f30f7e442404 }
            // n = 7, score = 700
            //   668b0424             | mov                 ax, word ptr [esp]
            //   6683e07f             | and                 ax, 0x7f
            //   6683f87f             | cmp                 ax, 0x7f
            //   8d642408             | lea                 esp, [esp + 8]
            //   0f85fd0b0000         | jne                 0xc03
            //   eb00                 | jmp                 2
            //   f30f7e442404         | movq                xmm0, qword ptr [esp + 4]

        $sequence_7 = { 50 ff15???????? 83c40c 6860070000 }
            // n = 4, score = 600
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6860070000           | push                0x760

        $sequence_8 = { 03d1 0fb6ca 8b55fc 0fb60c01 300c17 47 8a550b }
            // n = 7, score = 600
            //   03d1                 | add                 edx, ecx
            //   0fb6ca               | movzx               ecx, dl
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   0fb60c01             | movzx               ecx, byte ptr [ecx + eax]
            //   300c17               | xor                 byte ptr [edi + edx], cl
            //   47                   | inc                 edi
            //   8a550b               | mov                 dl, byte ptr [ebp + 0xb]

        $sequence_9 = { 8ab800010000 8a9001010000 57 33ff 8975f8 85f6 744e }
            // n = 7, score = 600
            //   8ab800010000         | mov                 bh, byte ptr [eax + 0x100]
            //   8a9001010000         | mov                 dl, byte ptr [eax + 0x101]
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   8975f8               | mov                 dword ptr [ebp - 8], esi
            //   85f6                 | test                esi, esi
            //   744e                 | je                  0x50

        $sequence_10 = { 744e fec7 0fb6f7 8a1c06 02d3 88550b 0fb6d2 }
            // n = 7, score = 600
            //   744e                 | je                  0x50
            //   fec7                 | inc                 bh
            //   0fb6f7               | movzx               esi, bh
            //   8a1c06               | mov                 bl, byte ptr [esi + eax]
            //   02d3                 | add                 dl, bl
            //   88550b               | mov                 byte ptr [ebp + 0xb], dl
            //   0fb6d2               | movzx               edx, dl

        $sequence_11 = { 47 8a550b 3b7df8 72c7 5f 8aca 88b800010000 }
            // n = 7, score = 600
            //   47                   | inc                 edi
            //   8a550b               | mov                 dl, byte ptr [ebp + 0xb]
            //   3b7df8               | cmp                 edi, dword ptr [ebp - 8]
            //   72c7                 | jb                  0xffffffc9
            //   5f                   | pop                 edi
            //   8aca                 | mov                 cl, dl
            //   88b800010000         | mov                 byte ptr [eax + 0x100], bh

        $sequence_12 = { ffd0 c3 8bff 55 8bec 83ec1c 8d4de4 }
            // n = 7, score = 500
            //   ffd0                 | call                eax
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec1c               | sub                 esp, 0x1c
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]

        $sequence_13 = { 8d85bcefffff 50 ff15???????? 68???????? }
            // n = 4, score = 500
            //   8d85bcefffff         | lea                 eax, [ebp - 0x1044]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_14 = { 68???????? 68???????? e8???????? 83c424 6aff }
            // n = 5, score = 500
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24
            //   6aff                 | push                -1

        $sequence_15 = { ff15???????? 68???????? 8d85dcf7ffff 50 }
            // n = 4, score = 500
            //   ff15????????         |                     
            //   68????????           |                     
            //   8d85dcf7ffff         | lea                 eax, [ebp - 0x824]
            //   50                   | push                eax

        $sequence_16 = { 6a00 e8???????? 83c408 6aff ff15???????? 33c0 }
            // n = 6, score = 400
            //   6a00                 | push                0
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 796672
}