rule win_cloud_duke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cloud_duke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cloud_duke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8a88e8ffff 33c8 e8???????? 83c008 8b4af8 33c8 }
            // n = 6, score = 800
            //   8b8a88e8ffff         | mov                 ecx, dword ptr [edx - 0x1778]
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     
            //   83c008               | add                 eax, 8
            //   8b4af8               | mov                 ecx, dword ptr [edx - 8]
            //   33c8                 | xor                 ecx, eax

        $sequence_1 = { 89442420 742b 48 89442414 6aff 6a00 57 }
            // n = 7, score = 800
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   742b                 | je                  0x2d
            //   48                   | dec                 eax
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   57                   | push                edi

        $sequence_2 = { e8???????? 51 8bc8 c645fc13 e8???????? 83c404 c645fc11 }
            // n = 7, score = 800
            //   e8????????           |                     
            //   51                   | push                ecx
            //   8bc8                 | mov                 ecx, eax
            //   c645fc13             | mov                 byte ptr [ebp - 4], 0x13
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c645fc11             | mov                 byte ptr [ebp - 4], 0x11

        $sequence_3 = { 897da4 6a13 6a00 68???????? 8bce e8???????? 83f8ff }
            // n = 7, score = 800
            //   897da4               | mov                 dword ptr [ebp - 0x5c], edi
            //   6a13                 | push                0x13
            //   6a00                 | push                0
            //   68????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1

        $sequence_4 = { 83e4f0 6aff 68???????? 64a100000000 50 81ec2c020000 }
            // n = 6, score = 800
            //   83e4f0               | and                 esp, 0xfffffff0
            //   6aff                 | push                -1
            //   68????????           |                     
            //   64a100000000         | mov                 eax, dword ptr fs:[0]
            //   50                   | push                eax
            //   81ec2c020000         | sub                 esp, 0x22c

        $sequence_5 = { 50 c784240c010000ffffffff e8???????? 8b842404010000 f7d0 39442428 0f8599060000 }
            // n = 7, score = 800
            //   50                   | push                eax
            //   c784240c010000ffffffff     | mov    dword ptr [esp + 0x10c], 0xffffffff
            //   e8????????           |                     
            //   8b842404010000       | mov                 eax, dword ptr [esp + 0x104]
            //   f7d0                 | not                 eax
            //   39442428             | cmp                 dword ptr [esp + 0x28], eax
            //   0f8599060000         | jne                 0x69f

        $sequence_6 = { 75f5 e9???????? 83f805 0f85b8020000 }
            // n = 4, score = 800
            //   75f5                 | jne                 0xfffffff7
            //   e9????????           |                     
            //   83f805               | cmp                 eax, 5
            //   0f85b8020000         | jne                 0x2be

        $sequence_7 = { 8bf0 e8???????? 83c414 39b42418010000 0f8572000000 6a44 }
            // n = 6, score = 800
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   39b42418010000       | cmp                 dword ptr [esp + 0x118], esi
            //   0f8572000000         | jne                 0x78
            //   6a44                 | push                0x44

        $sequence_8 = { 668906 8945fc 8b4310 8b7e10 83c007 c745f001000000 3bf8 }
            // n = 7, score = 800
            //   668906               | mov                 word ptr [esi], ax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]
            //   8b7e10               | mov                 edi, dword ptr [esi + 0x10]
            //   83c007               | add                 eax, 7
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   3bf8                 | cmp                 edi, eax

        $sequence_9 = { 0f57c0 0f43842420010000 51 8d8c24a0010000 }
            // n = 4, score = 800
            //   0f57c0               | xorps               xmm0, xmm0
            //   0f43842420010000     | cmovae              eax, dword ptr [esp + 0x120]
            //   51                   | push                ecx
            //   8d8c24a0010000       | lea                 ecx, [esp + 0x1a0]

    condition:
        7 of them and filesize < 368640
}