rule win_cobalt_strike_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cobalt_strike."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cobalt_strike"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bc7 750d ff15???????? 3d33270000 }
            // n = 4, score = 1900
            //   3bc7                 | dec                 eax
            //   750d                 | sub                 eax, 8
            //   ff15????????         |                     
            //   3d33270000           | xor                 edx, edx

        $sequence_1 = { e9???????? eb0a b801000000 e9???????? }
            // n = 4, score = 1900
            //   e9????????           |                     
            //   eb0a                 | dec                 eax
            //   b801000000           | mov                 eax, dword ptr [esp + 0x90]
            //   e9????????           |                     

        $sequence_2 = { ff15???????? 85c0 741d ff15???????? 85c0 7513 }
            // n = 6, score = 1100
            //   ff15????????         |                     
            //   85c0                 | jne                 0xf
            //   741d                 | cmp                 eax, 0x2733
            //   ff15????????         |                     
            //   85c0                 | jmp                 0xc
            //   7513                 | mov                 eax, 1

        $sequence_3 = { ff7608 83660400 e8???????? 59 }
            // n = 4, score = 1100
            //   ff7608               | test                al, 7
            //   83660400             | jne                 3
            //   e8????????           |                     
            //   59                   | dec                 esi

        $sequence_4 = { ff15???????? 59 a807 7501 4e }
            // n = 5, score = 1100
            //   ff15????????         |                     
            //   59                   | mov                 eax, dword ptr [eax + 0x50]
            //   a807                 | dec                 eax
            //   7501                 | mov                 ecx, dword ptr [esp + 0x88]
            //   4e                   | dec                 eax

        $sequence_5 = { ff75f8 ff75fc ff15???????? 83c40c eb15 ff75fc }
            // n = 6, score = 1100
            //   ff75f8               | mov                 eax, dword ptr [eax + 0x50]
            //   ff75fc               | dec                 eax
            //   ff15????????         |                     
            //   83c40c               | mov                 ecx, dword ptr [esp + 0x88]
            //   eb15                 | dec                 eax
            //   ff75fc               | lea                 eax, [ecx + eax - 0x40]

        $sequence_6 = { ff7604 ff75fc ff15???????? 83c410 }
            // n = 4, score = 1100
            //   ff7604               | mov                 byte ptr [esp + 0x5b], 0x64
            //   ff75fc               | cmp                 eax, edi
            //   ff15????????         |                     
            //   83c410               | jne                 0xf

        $sequence_7 = { ff15???????? 59 c70601000000 e9???????? }
            // n = 4, score = 1100
            //   ff15????????         |                     
            //   59                   | push                dword ptr [esi + 4]
            //   c70601000000         | push                dword ptr [ebp - 4]
            //   e9????????           |                     

        $sequence_8 = { ff7604 e8???????? 014604 83c410 014608 }
            // n = 5, score = 1100
            //   ff7604               | shr                 ax, 0xc
            //   e8????????           |                     
            //   014604               | mov                 byte ptr [esp + 0x58], 0x4c
            //   83c410               | mov                 byte ptr [esp + 0x59], 0x6f
            //   014608               | mov                 byte ptr [esp + 0x5a], 0x61

        $sequence_9 = { 85c0 7405 e8???????? 8b0d???????? 85c9 }
            // n = 5, score = 1000
            //   85c0                 | cmp                 eax, 0x2733
            //   7405                 | jmp                 0xc
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   85c9                 | mov                 eax, 1

        $sequence_10 = { e9???????? 833d????????01 7505 e8???????? }
            // n = 4, score = 900
            //   e9????????           |                     
            //   833d????????01       |                     
            //   7505                 | jmp                 0x3b
            //   e8????????           |                     

        $sequence_11 = { 8bd0 e8???????? 85c0 7e0e }
            // n = 4, score = 900
            //   8bd0                 | jge                 0x17
            //   e8????????           |                     
            //   85c0                 | mov                 eax, dword ptr [ebp + 8]
            //   7e0e                 | cmp                 eax, edi

        $sequence_12 = { f7d8 1bc9 4423f9 488d4ddf e8???????? }
            // n = 5, score = 800
            //   f7d8                 | je                  0x1f
            //   1bc9                 | test                eax, eax
            //   4423f9               | je                  0x1f
            //   488d4ddf             | test                eax, eax
            //   e8????????           |                     

        $sequence_13 = { c1ef03 8bc7 ffc0 81ff80000000 720b eb05 }
            // n = 6, score = 800
            //   c1ef03               | mov                 eax, 1
            //   8bc7                 | test                eax, eax
            //   ffc0                 | je                  0x1f
            //   81ff80000000         | test                eax, eax
            //   720b                 | jne                 0x19
            //   eb05                 | test                eax, eax

        $sequence_14 = { 488bd7 488bcf e8???????? 85c0 7569 498bcf }
            // n = 6, score = 800
            //   488bd7               | shr                 ebx, 0x1f
            //   488bcf               | dec                 ecx
            //   e8????????           |                     
            //   85c0                 | dec                 ebx
            //   7569                 | jne                 0xffffffe2
            //   498bcf               | inc                 esp

        $sequence_15 = { 83f801 750e e8???????? 4c8d2dca1e0000 eb16 e8???????? 8bd8 }
            // n = 7, score = 800
            //   83f801               | cmp                 eax, esi
            //   750e                 | jmp                 0xc
            //   e8????????           |                     
            //   4c8d2dca1e0000       | mov                 eax, 1
            //   eb16                 | cmp                 eax, edi
            //   e8????????           |                     
            //   8bd8                 | jne                 0xf

        $sequence_16 = { 7409 c745f040000000 eb07 c745f004000000 }
            // n = 4, score = 600
            //   7409                 | jmp                 0xf
            //   c745f040000000       | mov                 eax, 1
            //   eb07                 | mov                 dword ptr [ebp - 4], eax
            //   c745f004000000       | jmp                 9

        $sequence_17 = { 52 8b4508 8b08 ffd1 85c0 }
            // n = 5, score = 400
            //   52                   | inc                 ecx
            //   8b4508               | cmp                 edx, eax
            //   8b08                 | jge                 0x16
            //   ffd1                 | inc                 esp
            //   85c0                 | sub                 eax, edx

        $sequence_18 = { 837d0c00 7422 837d1000 761c 837d1404 }
            // n = 5, score = 400
            //   837d0c00             | test                eax, eax
            //   7422                 | je                  0x1f
            //   837d1000             | test                eax, eax
            //   761c                 | jne                 0x19
            //   837d1404             | test                eax, eax

        $sequence_19 = { 6a20 8b4d10 51 8b550c 52 }
            // n = 5, score = 400
            //   6a20                 | test                eax, eax
            //   8b4d10               | jne                 0x17
            //   51                   | test                eax, eax
            //   8b550c               | je                  0x1f
            //   52                   | test                eax, eax

        $sequence_20 = { 8b5514 52 8b450c 8b4850 }
            // n = 4, score = 400
            //   8b5514               | jmp                 0xc
            //   52                   | mov                 eax, 1
            //   8b450c               | cmp                 eax, edi
            //   8b4850               | jne                 0xf

        $sequence_21 = { 56 57 8b4510 8b4850 }
            // n = 4, score = 400
            //   56                   | mov                 edx, dword ptr [ebp + 0xc]
            //   57                   | push                edx
            //   8b4510               | mov                 eax, dword ptr [ebp + 8]
            //   8b4850               | je                  0x24

        $sequence_22 = { 8b4510 8b4850 8b550c 8d440ac0 }
            // n = 4, score = 400
            //   8b4510               | and                 eax, 0x8000
            //   8b4850               | je                  0x10
            //   8b550c               | mov                 dword ptr [ebp - 0x10], 0x40
            //   8d440ac0             | jmp                 0x10

        $sequence_23 = { b940000000 f3aa 5f 5e }
            // n = 4, score = 400
            //   b940000000           | je                  0x1f
            //   f3aa                 | test                eax, eax
            //   5f                   | test                eax, eax
            //   5e                   | je                  0x1f

        $sequence_24 = { 488b842490000000 8b4050 488b8c2488000000 488d4401c0 }
            // n = 4, score = 300
            //   488b842490000000     | lea                 edx, [esp + 0x58]
            //   8b4050               | dec                 eax
            //   488b8c2488000000     | mov                 ecx, dword ptr [esp + 0x20]
            //   488d4401c0           | mov                 byte ptr [esp + 0x54], 0

        $sequence_25 = { c644246856 c644246969 c644246a72 c644246b74 c644246c75 }
            // n = 5, score = 300
            //   c644246856           | mov                 byte ptr [esp + 0x68], 0x56
            //   c644246969           | mov                 byte ptr [esp + 0x69], 0x69
            //   c644246a72           | mov                 byte ptr [esp + 0x6a], 0x72
            //   c644246b74           | mov                 byte ptr [esp + 0x6b], 0x74
            //   c644246c75           | mov                 byte ptr [esp + 0x6c], 0x75

        $sequence_26 = { 4889442418 48837c242800 0f8496010000 488b0424 0fb700 66c1e80c }
            // n = 6, score = 300
            //   4889442418           | mov                 byte ptr [esp + 0x6c], 0x75
            //   48837c242800         | dec                 eax
            //   0f8496010000         | add                 ecx, eax
            //   488b0424             | dec                 eax
            //   0fb700               | mov                 eax, ecx
            //   66c1e80c             | dec                 eax

        $sequence_27 = { 4803c8 488bc1 4889442408 488b442410 8b4004 4883e808 33d2 }
            // n = 7, score = 300
            //   4803c8               | mov                 eax, dword ptr [esp + 0x90]
            //   488bc1               | call                dword ptr [eax + 8]
            //   4889442408           | dec                 eax
            //   488b442410           | mov                 ecx, dword ptr [esp + 0x90]
            //   8b4004               | dec                 eax
            //   4883e808             | mov                 dword ptr [ecx + 0x10], eax
            //   33d2                 | dec                 eax

        $sequence_28 = { 488bc1 4889442450 488b442450 4883c002 488b7c2420 }
            // n = 5, score = 300
            //   488bc1               | movzx               eax, cx
            //   4889442450           | movzx               eax, ax
            //   488b442450           | dec                 eax
            //   4883c002             | mov                 ecx, dword ptr [esp + 8]
            //   488b7c2420           | dec                 eax

        $sequence_29 = { 488b842490000000 ff5008 488b8c2490000000 48894110 488d542458 488b4c2420 }
            // n = 6, score = 300
            //   488b842490000000     | mov                 eax, dword ptr [ecx + eax]
            //   ff5008               | dec                 eax
            //   488b8c2490000000     | mov                 eax, ecx
            //   48894110             | dec                 eax
            //   488d542458           | mov                 dword ptr [esp + 0x50], eax
            //   488b4c2420           | dec                 eax

        $sequence_30 = { 488b0c24 0fb709 6623c8 0fb7c1 0fb7c0 488b4c2408 488b0401 }
            // n = 7, score = 300
            //   488b0c24             | call                dword ptr [eax]
            //   0fb709               | dec                 eax
            //   6623c8               | mov                 dword ptr [esp + 0x20], eax
            //   0fb7c1               | dec                 eax
            //   0fb7c0               | mov                 ecx, dword ptr [esp]
            //   488b4c2408           | movzx               ecx, word ptr [ecx]
            //   488b0401             | and                 cx, ax

        $sequence_31 = { c644247600 488d4c2428 488b842490000000 ff10 4889442420 }
            // n = 5, score = 300
            //   c644247600           | mov                 byte ptr [esp + 0x76], 0
            //   488d4c2428           | dec                 eax
            //   488b842490000000     | lea                 ecx, [esp + 0x28]
            //   ff10                 | dec                 eax
            //   4889442420           | mov                 eax, dword ptr [esp + 0x90]

    condition:
        7 of them and filesize < 1015808
}