rule win_cobint_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cobint."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cobint"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c418 a1???????? 03c9 891cc8 8b0d???????? a1???????? }
            // n = 6, score = 400
            //   83c418               | add                 esp, 0x18
            //   a1????????           |                     
            //   03c9                 | add                 ecx, ecx
            //   891cc8               | mov                 dword ptr [eax + ecx*8], ebx
            //   8b0d????????         |                     
            //   a1????????           |                     

        $sequence_1 = { 891cc8 8b0d???????? a1???????? 03c9 8974c804 8b0d???????? }
            // n = 6, score = 400
            //   891cc8               | mov                 dword ptr [eax + ecx*8], ebx
            //   8b0d????????         |                     
            //   a1????????           |                     
            //   03c9                 | add                 ecx, ecx
            //   8974c804             | mov                 dword ptr [eax + ecx*8 + 4], esi
            //   8b0d????????         |                     

        $sequence_2 = { c745f404000000 50 8d4508 50 6805000020 56 }
            // n = 6, score = 400
            //   c745f404000000       | mov                 dword ptr [ebp - 0xc], 4
            //   50                   | push                eax
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   6805000020           | push                0x20000005
            //   56                   | push                esi

        $sequence_3 = { 50 8d45f4 50 8d45ec 50 6813000020 ff75f0 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   6813000020           | push                0x20000013
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_4 = { 57 6a65 eb31 85db 743a }
            // n = 5, score = 400
            //   57                   | push                edi
            //   6a65                 | push                0x65
            //   eb31                 | jmp                 0x33
            //   85db                 | test                ebx, ebx
            //   743a                 | je                  0x3c

        $sequence_5 = { e8???????? 83c410 eb60 6a01 8d450f }
            // n = 5, score = 400
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   eb60                 | jmp                 0x62
            //   6a01                 | push                1
            //   8d450f               | lea                 eax, [ebp + 0xf]

        $sequence_6 = { 57 bf00020000 57 e8???????? 57 6a00 }
            // n = 6, score = 400
            //   57                   | push                edi
            //   bf00020000           | mov                 edi, 0x200
            //   57                   | push                edi
            //   e8????????           |                     
            //   57                   | push                edi
            //   6a00                 | push                0

        $sequence_7 = { 83f820 7cf3 eb07 8bf0 c1e604 03f2 57 }
            // n = 7, score = 400
            //   83f820               | cmp                 eax, 0x20
            //   7cf3                 | jl                  0xfffffff5
            //   eb07                 | jmp                 9
            //   8bf0                 | mov                 esi, eax
            //   c1e604               | shl                 esi, 4
            //   03f2                 | add                 esi, edx
            //   57                   | push                edi

        $sequence_8 = { 740d 8b5508 0355f0 8a45ec }
            // n = 4, score = 200
            //   740d                 | je                  0xf
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0355f0               | add                 edx, dword ptr [ebp - 0x10]
            //   8a45ec               | mov                 al, byte ptr [ebp - 0x14]

        $sequence_9 = { 31b7807c30ae 807c909090 90 bdfd807c90 }
            // n = 4, score = 200
            //   31b7807c30ae         | xor                 dword ptr [edi - 0x51cf8380], esi
            //   807c909090           | cmp                 byte ptr [eax + edx*4 - 0x70], 0x90
            //   90                   | nop                 
            //   bdfd807c90           | mov                 ebp, 0x907c80fd

        $sequence_10 = { 8bcb 897db8 e8???????? 8bf0 }
            // n = 4, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   897db8               | mov                 dword ptr [ebp - 0x48], edi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_11 = { 81ffea968891 740a 33c0 8b12 85d2 }
            // n = 5, score = 200
            //   81ffea968891         | cmp                 edi, 0x918896ea
            //   740a                 | je                  0xc
            //   33c0                 | xor                 eax, eax
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   85d2                 | test                edx, edx

        $sequence_12 = { ffd6 eb03 8b75e4 ff75d8 ffd6 }
            // n = 5, score = 200
            //   ffd6                 | call                esi
            //   eb03                 | jmp                 5
            //   8b75e4               | mov                 esi, dword ptr [ebp - 0x1c]
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   ffd6                 | call                esi

        $sequence_13 = { 395318 763c 8b3c90 33c0 03fe }
            // n = 5, score = 200
            //   395318               | cmp                 dword ptr [ebx + 0x18], edx
            //   763c                 | jbe                 0x3e
            //   8b3c90               | mov                 edi, dword ptr [eax + edx*4]
            //   33c0                 | xor                 eax, eax
            //   03fe                 | add                 edi, esi

        $sequence_14 = { 90 90 90 e10b }
            // n = 4, score = 200
            //   90                   | nop                 
            //   90                   | nop                 
            //   90                   | nop                 
            //   e10b                 | loope               0xd

        $sequence_15 = { b800a80000 2bc7 50 56 53 ff55f8 85c0 }
            // n = 7, score = 200
            //   b800a80000           | mov                 eax, 0xa800
            //   2bc7                 | sub                 eax, edi
            //   50                   | push                eax
            //   56                   | push                esi
            //   53                   | push                ebx
            //   ff55f8               | call                dword ptr [ebp - 8]
            //   85c0                 | test                eax, eax

        $sequence_16 = { 8802 eb0b 8b4d08 034df0 }
            // n = 4, score = 200
            //   8802                 | mov                 byte ptr [edx], al
            //   eb0b                 | jmp                 0xd
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   034df0               | add                 ecx, dword ptr [ebp - 0x10]

        $sequence_17 = { bffc807c28 1a807c170e81 7cd7 9b 807c909090 90 90 }
            // n = 7, score = 200
            //   bffc807c28           | mov                 edi, 0x287c80fc
            //   1a807c170e81         | sbb                 al, byte ptr [eax - 0x7ef1e884]
            //   7cd7                 | jl                  0xffffffd9
            //   9b                   | wait                
            //   807c909090           | cmp                 byte ptr [eax + edx*4 - 0x70], 0x90
            //   90                   | nop                 
            //   90                   | nop                 

        $sequence_18 = { 749b 807ce19a80 7c90 90 }
            // n = 4, score = 200
            //   749b                 | je                  0xffffff9d
            //   807ce19a80           | cmp                 byte ptr [ecx - 0x66], 0x80
            //   7c90                 | jl                  0xffffff92
            //   90                   | nop                 

        $sequence_19 = { 90 e10b 96 7c90 90 }
            // n = 5, score = 200
            //   90                   | nop                 
            //   e10b                 | loope               0xd
            //   96                   | xchg                eax, esi
            //   7c90                 | jl                  0xffffff92
            //   90                   | nop                 

        $sequence_20 = { bab1c50790 8bf0 33ff e8???????? 8d4dec 8945f8 }
            // n = 6, score = 200
            //   bab1c50790           | mov                 edx, 0x9007c5b1
            //   8bf0                 | mov                 esi, eax
            //   33ff                 | xor                 edi, edi
            //   e8????????           |                     
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_21 = { ffd0 85c0 0f8406010000 8b4de0 ba6a62f095 }
            // n = 5, score = 200
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   0f8406010000         | je                  0x10c
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   ba6a62f095           | mov                 edx, 0x95f0626a

        $sequence_22 = { e8???????? 8945f8 8d45c4 50 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8d45c4               | lea                 eax, [ebp - 0x3c]
            //   50                   | push                eax

        $sequence_23 = { e8???????? 58 83c005 c3 31b7807c30ae }
            // n = 5, score = 200
            //   e8????????           |                     
            //   58                   | pop                 eax
            //   83c005               | add                 eax, 5
            //   c3                   | ret                 
            //   31b7807c30ae         | xor                 dword ptr [edi - 0x51cf8380], esi

    condition:
        7 of them and filesize < 65536
}