rule win_cobra_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.cobra."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.cobra"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7511 e8???????? 85c0 7508 ff15???????? }
            // n = 5, score = 2900
            //   7511                 | jne                 0xc
            //   e8????????           |                     
            //   85c0                 | mov                 eax, dword ptr [esp + 8]
            //   7508                 | test                eax, eax
            //   ff15????????         |                     

        $sequence_1 = { c20c00 ff25???????? 53 56 57 8bd9 33f6 }
            // n = 7, score = 2500
            //   c20c00               | ret                 
            //   ff25????????         |                     
            //   53                   | mov                 ax, cs
            //   56                   | ret                 
            //   57                   | push                ebx
            //   8bd9                 | push                eax
            //   33f6                 | test                eax, eax

        $sequence_2 = { 5e 5b c3 83fb01 7405 83fb02 7537 }
            // n = 7, score = 2500
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   83fb01               | cmp                 ebx, 1
            //   7405                 | je                  7
            //   83fb02               | cmp                 ebx, 2
            //   7537                 | jne                 0x39

        $sequence_3 = { 7514 391d???????? 754d 33c0 }
            // n = 4, score = 2500
            //   7514                 | jne                 0x16
            //   391d????????         |                     
            //   754d                 | jne                 0x4f
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 8b442438 85c0 757f 8b05???????? }
            // n = 4, score = 2500
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   85c0                 | test                eax, eax
            //   757f                 | jne                 0x81
            //   8b05????????         |                     

        $sequence_5 = { 751c 8bcf ff15???????? 8d8fe8030000 8bf9 }
            // n = 5, score = 2500
            //   751c                 | jne                 0x1e
            //   8bcf                 | mov                 ecx, edi
            //   ff15????????         |                     
            //   8d8fe8030000         | lea                 ecx, [edi + 0x3e8]
            //   8bf9                 | mov                 edi, ecx

        $sequence_6 = { ff25???????? 8b442408 85c0 750e 3905???????? 7e2c }
            // n = 6, score = 2500
            //   ff25????????         |                     
            //   8b442408             | je                  0xc
            //   85c0                 | mov                 eax, 0xc0000005
            //   750e                 | test                eax, eax
            //   3905????????         |                     
            //   7e2c                 | je                  0xc

        $sequence_7 = { 5b c3 85db 7405 83fb03 753b }
            // n = 6, score = 2500
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   85db                 | test                ebx, ebx
            //   7405                 | je                  7
            //   83fb03               | cmp                 ebx, 3
            //   753b                 | jne                 0x3d

        $sequence_8 = { 757f 8b05???????? 85c0 0f8e8c000000 83e801 8905???????? }
            // n = 6, score = 2500
            //   757f                 | jne                 0x81
            //   8b05????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8e8c000000         | jle                 0x92
            //   83e801               | sub                 eax, 1
            //   8905????????         |                     

        $sequence_9 = { e8???????? 8bf8 83fb01 751d 85ff }
            // n = 5, score = 2500
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83fb01               | cmp                 ebx, 1
            //   751d                 | jne                 0x1f
            //   85ff                 | test                edi, edi

        $sequence_10 = { 5f 5e 5b c3 85ff 7418 }
            // n = 6, score = 2500
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   85ff                 | test                edi, edi
            //   7418                 | je                  0x1a

        $sequence_11 = { 33d2 b9e8030000 f7f1 83f805 }
            // n = 4, score = 2300
            //   33d2                 | push                3
            //   b9e8030000           | push                0xc0000000
            //   f7f1                 | mov                 dword ptr [eax], ecx
            //   83f805               | mov                 dword ptr [eax + 4], edx

        $sequence_12 = { 813c0850450000 7503 33c0 c3 }
            // n = 4, score = 2100
            //   813c0850450000       | push                eax
            //   7503                 | mov                 dword ptr [ebp - 0x30], 0
            //   33c0                 | mov                 dword ptr [ebp - 0x2c], 0
            //   c3                   | lea                 eax, [ebp - 0x40]

        $sequence_13 = { e8???????? ff463c 57 e8???????? }
            // n = 4, score = 1900
            //   e8????????           |                     
            //   ff463c               | jle                 0x30
            //   57                   | mov                 eax, dword ptr [esp + 8]
            //   e8????????           |                     

        $sequence_14 = { ff15???????? 53 ff7714 8bf0 ff571c 59 }
            // n = 6, score = 1900
            //   ff15????????         |                     
            //   53                   | mov                 dword ptr [ebp - 0x2c], 0
            //   ff7714               | lea                 edx, [ebp - 0x40]
            //   8bf0                 | push                edx
            //   ff571c               | ret                 0xc
            //   59                   | push                ebx

        $sequence_15 = { 7407 33c0 e9???????? ff15???????? e9???????? }
            // n = 5, score = 1900
            //   7407                 | push                eax
            //   33c0                 | mov                 ecx, dword ptr [ebp - 0x4c]
            //   e9????????           |                     
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_16 = { 8b742408 837e0c00 7507 b865005921 5e c3 837e2800 }
            // n = 7, score = 1900
            //   8b742408             | jne                 0x10
            //   837e0c00             | xor                 edi, edi
            //   7507                 | mov                 eax, edi
            //   b865005921           | mov                 eax, dword ptr [esp + 8]
            //   5e                   | test                eax, eax
            //   c3                   | jne                 0x12
            //   837e2800             | jle                 0x32

        $sequence_17 = { 7f07 e8???????? eb26 83c0ff }
            // n = 4, score = 1200
            //   7f07                 | jg                  9
            //   e8????????           |                     
            //   eb26                 | jmp                 0x28
            //   83c0ff               | add                 eax, -1

        $sequence_18 = { e8???????? 33db 3bc3 741a }
            // n = 4, score = 1200
            //   e8????????           |                     
            //   33db                 | xor                 ebx, ebx
            //   3bc3                 | cmp                 eax, ebx
            //   741a                 | je                  0x1c

        $sequence_19 = { e8???????? eb6d e8???????? 85c0 7564 }
            // n = 5, score = 1200
            //   e8????????           |                     
            //   eb6d                 | jmp                 0x6f
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7564                 | jne                 0x66

        $sequence_20 = { ebe4 4533f6 413bee 75f4 }
            // n = 4, score = 1100
            //   ebe4                 | jle                 0x56
            //   4533f6               | dec                 esp
            //   413bee               | mov                 edx, dword ptr [eax + 0x5c]
            //   75f4                 | dec                 ebp

        $sequence_21 = { 7564 488b0b 488b01 83385c 7e4b 4c8b505c }
            // n = 6, score = 1100
            //   7564                 | test                eax, eax
            //   488b0b               | jne                 0x12
            //   488b01               | dec                 eax
            //   83385c               | and                 dword ptr [edi], 0
            //   7e4b                 | dec                 ecx
            //   4c8b505c             | mov                 ecx, esi

        $sequence_22 = { e8???????? 498bce 85c0 750e }
            // n = 4, score = 1100
            //   e8????????           |                     
            //   498bce               | dec                 ecx
            //   85c0                 | mov                 ecx, esi
            //   750e                 | test                eax, eax

        $sequence_23 = { 7548 488b05???????? 4885c0 743c 488b8c24a0000000 }
            // n = 5, score = 1100
            //   7548                 | mov                 ecx, dword ptr [ebx]
            //   488b05????????       |                     
            //   4885c0               | dec                 eax
            //   743c                 | mov                 eax, dword ptr [ecx]
            //   488b8c24a0000000     | cmp                 dword ptr [eax], 0x5c

        $sequence_24 = { e8???????? 498bce e8???????? 48832700 }
            // n = 4, score = 1100
            //   e8????????           |                     
            //   498bce               | dec                 ecx
            //   e8????????           |                     
            //   48832700             | mov                 ecx, esi

        $sequence_25 = { 7504 33c0 eb05 b865005921 }
            // n = 4, score = 900
            //   7504                 | and                 dword ptr [edi], 0
            //   33c0                 | mov                 edx, 2
            //   eb05                 | mov                 edx, 1
            //   b865005921           | dec                 eax

        $sequence_26 = { 83781400 750a b865005921 e9???????? }
            // n = 4, score = 900
            //   83781400             | dec                 ecx
            //   750a                 | mov                 ecx, esi
            //   b865005921           | dec                 eax
            //   e9????????           |                     

        $sequence_27 = { 663bcb 75f4 8b15???????? 8b0d???????? 8910 8b15???????? }
            // n = 6, score = 800
            //   663bcb               | push                dword ptr [edi + 0x14]
            //   75f4                 | mov                 esi, eax
            //   8b15????????         |                     
            //   8b0d????????         |                     
            //   8910                 | call                dword ptr [edi + 0x1c]
            //   8b15????????         |                     

        $sequence_28 = { ff15???????? 83f87a 740b 3d230000c0 }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   83f87a               | push                edi
            //   740b                 | mov                 ebx, ecx
            //   3d230000c0           | xor                 esi, esi

        $sequence_29 = { 51 e8???????? 33c0 83c43c }
            // n = 4, score = 800
            //   51                   | cmp                 cx, bx
            //   e8????????           |                     
            //   33c0                 | jne                 0xfffffff9
            //   83c43c               | mov                 dword ptr [eax], edx

        $sequence_30 = { 6689440ffc 6685c0 75ee f685c003000010 }
            // n = 4, score = 800
            //   6689440ffc           | jne                 0x13
            //   6685c0               | test                eax, eax
            //   75ee                 | jne                 0xa
            //   f685c003000010       | jne                 0x13

        $sequence_31 = { ff15???????? eb03 8b7d0c 3bfb }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   eb03                 | pop                 ebp
            //   8b7d0c               | ret                 
            //   3bfb                 | mov                 ecx, dword ptr [ebp + 8]

        $sequence_32 = { 51 6a00 6a00 56 ff15???????? 56 }
            // n = 6, score = 800
            //   51                   | xor                 eax, eax
            //   6a00                 | cmp                 eax, -1
            //   6a00                 | je                  0xc
            //   56                   | xor                 eax, eax
            //   ff15????????         |                     
            //   56                   | push                ebx

        $sequence_33 = { 6a03 68000000c0 50 ff15???????? 8bf0 83feff 7505 }
            // n = 7, score = 800
            //   6a03                 | mov                 eax, dword ptr [esp + 8]
            //   68000000c0           | test                eax, eax
            //   50                   | jne                 0x10
            //   ff15????????         |                     
            //   8bf0                 | jle                 0x30
            //   83feff               | cmp                 dword ptr [eax + ecx], 0x4550
            //   7505                 | jne                 0xc

        $sequence_34 = { 83feff 7505 33c0 5e 5d c3 8b4d08 }
            // n = 7, score = 800
            //   83feff               | push                0
            //   7505                 | add                 eax, 2
            //   33c0                 | cmp                 cx, bx
            //   5e                   | jne                 0xfffffff6
            //   5d                   | mov                 dword ptr [eax], edx
            //   c3                   | ret                 
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_35 = { 50 6a00 6aff e8???????? 85c0 7405 }
            // n = 6, score = 800
            //   50                   | mov                 ecx, edi
            //   6a00                 | xor                 ebx, ebx
            //   6aff                 | cmp                 eax, ebx
            //   e8????????           |                     
            //   85c0                 | je                  0x23
            //   7405                 | jmp                 0xffffffe6

        $sequence_36 = { 8bec 56 6a00 6880000000 6a03 6a00 6a03 }
            // n = 7, score = 800
            //   8bec                 | mov                 dword ptr [eax], edx
            //   56                   | push                ecx
            //   6a00                 | xor                 eax, eax
            //   6880000000           | add                 esp, 0x3c
            //   6a03                 | push                ecx
            //   6a00                 | push                0
            //   6a03                 | push                0

        $sequence_37 = { 5d c3 8b4d08 57 51 6a00 }
            // n = 6, score = 800
            //   5d                   | xor                 eax, eax
            //   c3                   | ret                 
            //   8b4d08               | je                  9
            //   57                   | xor                 eax, eax
            //   51                   | cmp                 eax, -1
            //   6a00                 | je                  0xc

        $sequence_38 = { b914000000 84c0 0f45f9 488bce 8bd7 ff15???????? 85c0 }
            // n = 7, score = 700
            //   b914000000           | test                eax, eax
            //   84c0                 | jne                 0xa
            //   0f45f9               | xor                 edx, edx
            //   488bce               | mov                 ecx, 0x3e8
            //   8bd7                 | div                 ecx
            //   ff15????????         |                     
            //   85c0                 | cmp                 eax, 5

        $sequence_39 = { 4584ff 7518 33c0 4881c4480d0000 }
            // n = 4, score = 700
            //   4584ff               | dec                 eax
            //   7518                 | mov                 ecx, esi
            //   33c0                 | mov                 edx, edi
            //   4881c4480d0000       | inc                 ebp

        $sequence_40 = { 8d8588feffff 68???????? 50 ff15???????? 83c42c }
            // n = 5, score = 700
            //   8d8588feffff         | jne                 0x41
            //   68????????           |                     
            //   50                   | pop                 edi
            //   ff15????????         |                     
            //   83c42c               | pop                 esi

        $sequence_41 = { 4533e4 4c8bf1 488bda 488d8d10060000 33d2 41b808020000 4489a5800c0000 }
            // n = 7, score = 700
            //   4533e4               | dec                 eax
            //   4c8bf1               | mov                 ecx, esi
            //   488bda               | mov                 edx, edi
            //   488d8d10060000       | dec                 eax
            //   33d2                 | mov                 ecx, esi
            //   41b808020000         | mov                 edx, edi
            //   4489a5800c0000       | test                eax, eax

        $sequence_42 = { 4c89642448 488d4c2468 48894c2440 4c89642438 }
            // n = 4, score = 700
            //   4c89642448           | xor                 eax, eax
            //   488d4c2468           | cmp                 eax, -1
            //   48894c2440           | je                  0xc
            //   4c89642438           | xor                 eax, eax

        $sequence_43 = { 33d2 488bc8 ff15???????? 488bcf ff15???????? 41b701 }
            // n = 6, score = 700
            //   33d2                 | cmovne              edi, ecx
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488bcf               | mov                 ecx, esi
            //   ff15????????         |                     
            //   41b701               | mov                 edx, edi

        $sequence_44 = { 56 4154 4156 4157 488dac24b8f3ffff }
            // n = 5, score = 700
            //   56                   | dec                 eax
            //   4154                 | mov                 dword ptr [esp + 0x50], ecx
            //   4156                 | dec                 esp
            //   4157                 | mov                 dword ptr [esp + 0x48], esp
            //   488dac24b8f3ffff     | dec                 eax

        $sequence_45 = { 7507 32c0 e9???????? c745b818000000 }
            // n = 4, score = 600
            //   7507                 | je                  0xb
            //   32c0                 | push                0
            //   e9????????           |                     
            //   c745b818000000       | push                -1

        $sequence_46 = { 668b08 83c002 6685c9 75f5 2bc2 d1f8 66837c43fe5c }
            // n = 7, score = 500
            //   668b08               | pop                 ebx
            //   83c002               | ret                 
            //   6685c9               | test                ebx, ebx
            //   75f5                 | je                  0xb
            //   2bc2                 | cmp                 ebx, 3
            //   d1f8                 | pop                 edi
            //   66837c43fe5c         | pop                 esi

        $sequence_47 = { 33f6 03c2 13ce 51 50 }
            // n = 5, score = 500
            //   33f6                 | test                eax, eax
            //   03c2                 | je                  9
            //   13ce                 | push                eax
            //   51                   | push                0
            //   50                   | push                -1

        $sequence_48 = { 0f8456feffff 807c241301 6800080000 0f8544020000 }
            // n = 4, score = 300
            //   0f8456feffff         | test                cx, cx
            //   807c241301           | jne                 0xfffffff7
            //   6800080000           | sub                 eax, edx
            //   0f8544020000         | sar                 eax, 1

        $sequence_49 = { 05a1000000 50 8d84249c0d0000 68???????? }
            // n = 4, score = 300
            //   05a1000000           | cmp                 ebx, 1
            //   50                   | je                  0xb
            //   8d84249c0d0000       | cmp                 ebx, 2
            //   68????????           |                     

        $sequence_50 = { 05a2000000 50 8d8c249c0d0000 68???????? }
            // n = 4, score = 300
            //   05a2000000           | ret                 
            //   50                   | cmp                 ebx, 1
            //   8d8c249c0d0000       | je                  0xa
            //   68????????           |                     

        $sequence_51 = { 0f84100f0000 6800080000 57 56 }
            // n = 4, score = 300
            //   0f84100f0000         | pop                 ebx
            //   6800080000           | ret                 
            //   57                   | test                ebx, ebx
            //   56                   | je                  0xb

        $sequence_52 = { 0f8431ffffff 8b4d08 5f 8931 }
            // n = 4, score = 300
            //   0f8431ffffff         | test                eax, eax
            //   8b4d08               | jle                 0x94
            //   5f                   | test                eax, eax
            //   8931                 | jne                 0x10

        $sequence_53 = { 05a2000000 50 8d94249c0d0000 68???????? }
            // n = 4, score = 300
            //   05a2000000           | pop                 ebx
            //   50                   | ret                 
            //   8d94249c0d0000       | test                edi, edi
            //   68????????           |                     

        $sequence_54 = { 85c0 740a b8050000c0 e9???????? }
            // n = 4, score = 200
            //   85c0                 | push                -1
            //   740a                 | test                eax, eax
            //   b8050000c0           | lea                 eax, [ebp - 0x18]
            //   e9????????           |                     

        $sequence_55 = { 668cc8 c3 53 50 }
            // n = 4, score = 200
            //   668cc8               | push                0x18
            //   c3                   | lea                 eax, [ebp - 0x18]
            //   53                   | push                eax
            //   50                   | push                0

        $sequence_56 = { c745d000000000 c745d400000000 8d45c0 50 e8???????? }
            // n = 5, score = 100
            //   c745d000000000       | adc                 ecx, esi
            //   c745d400000000       | push                ecx
            //   8d45c0               | push                eax
            //   50                   | xor                 esi, esi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1368064
}