rule win_colibri_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.colibri."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.colibri"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8598fdffff 6804010000 50 6a02 59 }
            // n = 5, score = 100
            //   8d8598fdffff         | lea                 eax, [ebp - 0x268]
            //   6804010000           | push                0x104
            //   50                   | push                eax
            //   6a02                 | push                2
            //   59                   | pop                 ecx

        $sequence_1 = { 50 6a02 59 e8???????? babab69c31 8bc8 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   6a02                 | push                2
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   babab69c31           | mov                 edx, 0x319cb6ba
            //   8bc8                 | mov                 ecx, eax

        $sequence_2 = { a1???????? 81ec90080000 53 56 57 8d0c4502000000 e8???????? }
            // n = 7, score = 100
            //   a1????????           |                     
            //   81ec90080000         | sub                 esp, 0x890
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d0c4502000000       | lea                 ecx, [eax*2 + 2]
            //   e8????????           |                     

        $sequence_3 = { 59 e8???????? ba980aa4bf 8bc8 e8???????? ffd0 8945ec }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   ba980aa4bf           | mov                 edx, 0xbfa40a98
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   ffd0                 | call                eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_4 = { 8b4dd0 8d144502000000 e8???????? a1???????? 8b4dcc 8d144502000000 e8???????? }
            // n = 7, score = 100
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   8d144502000000       | lea                 edx, [eax*2 + 2]
            //   e8????????           |                     
            //   a1????????           |                     
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   8d144502000000       | lea                 edx, [eax*2 + 2]
            //   e8????????           |                     

        $sequence_5 = { e8???????? 53 8bf0 56 6aff 57 6a00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   53                   | push                ebx
            //   8bf0                 | mov                 esi, eax
            //   56                   | push                esi
            //   6aff                 | push                -1
            //   57                   | push                edi
            //   6a00                 | push                0

        $sequence_6 = { 8365f800 50 e8???????? 59 85c0 7413 8b4dfc }
            // n = 7, score = 100
            //   8365f800             | and                 dword ptr [ebp - 8], 0
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_7 = { ffd0 e8???????? 8b75d0 85c0 }
            // n = 4, score = 100
            //   ffd0                 | call                eax
            //   e8????????           |                     
            //   8b75d0               | mov                 esi, dword ptr [ebp - 0x30]
            //   85c0                 | test                eax, eax

        $sequence_8 = { 8945fc b944000000 b000 8b7dfc }
            // n = 4, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   b944000000           | mov                 ecx, 0x44
            //   b000                 | mov                 al, 0
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]

        $sequence_9 = { 50 68e9fd0000 6a02 59 e8???????? bac0bc4316 8bc8 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   68e9fd0000           | push                0xfde9
            //   6a02                 | push                2
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   bac0bc4316           | mov                 edx, 0x1643bcc0
            //   8bc8                 | mov                 ecx, eax

    condition:
        7 of them and filesize < 51200
}