rule win_collection_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.collection_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.collection_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4885d2 740b 41b001 488bce e8???????? e8???????? }
            // n = 6, score = 100
            //   4885d2               | dec                 eax
            //   740b                 | and                 dword ptr [esp + 0x60], 0
            //   41b001               | dec                 eax
            //   488bce               | mov                 ecx, eax
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_1 = { 8d7e78 448bc3 8bd7 e8???????? 448bce 4c8d442440 8d5601 }
            // n = 7, score = 100
            //   8d7e78               | mov                 edx, dword ptr [ecx + 0x10]
            //   448bc3               | dec                 eax
            //   8bd7                 | cmp                 edx, 0x40
            //   e8????????           |                     
            //   448bce               | jbe                 0x5b3
            //   4c8d442440           | dec                 eax
            //   8d5601               | shr                 edx, 2

        $sequence_2 = { 488bce e8???????? e8???????? 488bc8 baa3000000 e8???????? 488b8f80000000 }
            // n = 7, score = 100
            //   488bce               | mov                 eax, eax
            //   e8????????           |                     
            //   e8????????           |                     
            //   488bc8               | dec                 eax
            //   baa3000000           | mov                 edx, esi
            //   e8????????           |                     
            //   488b8f80000000       | dec                 eax

        $sequence_3 = { bf18000000 448bc7 33d2 488d8c24a8000000 e8???????? 89bc24a8000000 c78424b800000001000000 }
            // n = 7, score = 100
            //   bf18000000           | dec                 eax
            //   448bc7               | mov                 ecx, ebx
            //   33d2                 | xor                 edi, edi
            //   488d8c24a8000000     | mov                 ebp, eax
            //   e8????????           |                     
            //   89bc24a8000000       | test                eax, eax
            //   c78424b800000001000000     | jle    0x888

        $sequence_4 = { 410fb7cc eb4a 80f92b 7507 b93e000000 eb3e }
            // n = 6, score = 100
            //   410fb7cc             | xor                 ecx, ecx
            //   eb4a                 | lea                 edx, [edi + 0x71]
            //   80f92b               | mov                 ecx, edi
            //   7507                 | inc                 esp
            //   b93e000000           | lea                 eax, [edi + 0x6b]
            //   eb3e                 | mov                 edx, ebx

        $sequence_5 = { e8???????? eb27 488b5950 e8???????? 488bc8 ba98000000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb27                 | dec                 eax
            //   488b5950             | mov                 ecx, eax
            //   e8????????           |                     
            //   488bc8               | dec                 eax
            //   ba98000000           | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     

        $sequence_6 = { c3 418bc4 ebdc 4885d2 0f84aa020000 48895c2408 57 }
            // n = 7, score = 100
            //   c3                   | mov                 ecx, ebx
            //   418bc4               | jmp                 0x9bf
            //   ebdc                 | lea                 ecx, [edi + 1]
            //   4885d2               | dec                 eax
            //   0f84aa020000         | mov                 dword ptr [ebx], eax
            //   48895c2408           | mov                 edi, ebp
            //   57                   | dec                 eax

        $sequence_7 = { 488b4c2470 e8???????? eb14 89442420 4533c9 4533c0 }
            // n = 6, score = 100
            //   488b4c2470           | shr                 al, 7
            //   e8????????           |                     
            //   eb14                 | add                 dl, dl
            //   89442420             | movzx               eax, al
            //   4533c9               | inc                 ecx
            //   4533c0               | xor                 cl, dl

        $sequence_8 = { 4183e801 7429 4183e801 741e 4183e801 740f 4183f801 }
            // n = 7, score = 100
            //   4183e801             | inc                 ecx
            //   7429                 | test                dl, 3
            //   4183e801             | jne                 0xacb
            //   741e                 | lea                 eax, [edx - 1]
            //   4183e801             | inc                 edx
            //   740f                 | mov                 ch, byte ptr [eax + ecx]
            //   4183f801             | inc                 ecx

        $sequence_9 = { 4883ec20 4c8b7150 488bd9 b900100000 }
            // n = 4, score = 100
            //   4883ec20             | dec                 eax
            //   4c8b7150             | lea                 ecx, [ebx + 0x6a0]
            //   488bd9               | inc                 esp
            //   b900100000           | mov                 eax, esi

    condition:
        7 of them and filesize < 397312
}