rule win_collectorgoomba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.collectorgoomba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.collectorgoomba"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff30 ff7508 e8???????? 59 59 898504ffffff 6af7 }
            // n = 7, score = 200
            //   ff30                 | push                dword ptr [eax]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   898504ffffff         | mov                 dword ptr [ebp - 0xfc], eax
            //   6af7                 | push                -9

        $sequence_1 = { 8b45f4 c1e803 8b4d08 8b4954 0fb60401 8b4df4 83e107 }
            // n = 7, score = 200
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   c1e803               | shr                 eax, 3
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b4954               | mov                 ecx, dword ptr [ecx + 0x54]
            //   0fb60401             | movzx               eax, byte ptr [ecx + eax]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   83e107               | and                 ecx, 7

        $sequence_2 = { ff75fc e8???????? 83c410 ff75c8 ff7588 6a7a ff75fc }
            // n = 7, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   ff75c8               | push                dword ptr [ebp - 0x38]
            //   ff7588               | push                dword ptr [ebp - 0x78]
            //   6a7a                 | push                0x7a
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_3 = { ff702c ff7508 e8???????? 83c40c ff75f4 6a24 ff75fc }
            // n = 7, score = 200
            //   ff702c               | push                dword ptr [eax + 0x2c]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   6a24                 | push                0x24
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_4 = { ff750c ff75e8 ff75e4 e8???????? 83c414 8b4df4 64890d00000000 }
            // n = 7, score = 200
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_5 = { ff15???????? 59 8b4514 83e002 7421 ff7518 8b4514 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   83e002               | and                 eax, 2
            //   7421                 | je                  0x23
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_6 = { ffb594feffff ffb590feffff e8???????? 83c40c c645fc23 8d8d54fcffff e8???????? }
            // n = 7, score = 200
            //   ffb594feffff         | push                dword ptr [ebp - 0x16c]
            //   ffb590feffff         | push                dword ptr [ebp - 0x170]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c645fc23             | mov                 byte ptr [ebp - 4], 0x23
            //   8d8d54fcffff         | lea                 ecx, [ebp - 0x3ac]
            //   e8????????           |                     

        $sequence_7 = { ff75f8 e8???????? 83c418 33c0 40 e9???????? 8b450c }
            // n = 7, score = 200
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   e9????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_8 = { ffb558ffffff ffb554ffffff 8b4508 ff30 e8???????? 83c418 8945d0 }
            // n = 7, score = 200
            //   ffb558ffffff         | push                dword ptr [ebp - 0xa8]
            //   ffb554ffffff         | push                dword ptr [ebp - 0xac]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax

        $sequence_9 = { ffb518ffffff 8d8500fdffff 50 e8???????? 83c40c 898514ffffff 8b8514ffffff }
            // n = 7, score = 200
            //   ffb518ffffff         | push                dword ptr [ebp - 0xe8]
            //   8d8500fdffff         | lea                 eax, [ebp - 0x300]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   898514ffffff         | mov                 dword ptr [ebp - 0xec], eax
            //   8b8514ffffff         | mov                 eax, dword ptr [ebp - 0xec]

    condition:
        7 of them and filesize < 1400832
}