rule win_comebacker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.comebacker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.comebacker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6683f809 7f04 0430 eb02 0437 }
            // n = 5, score = 500
            //   6683f809             | cmp                 ax, 9
            //   7f04                 | jg                  6
            //   0430                 | add                 al, 0x30
            //   eb02                 | jmp                 4
            //   0437                 | add                 al, 0x37

        $sequence_1 = { baa2000000 4c8d0d47450300 b910000000 448d42a0 }
            // n = 4, score = 400
            //   baa2000000           | mov                 edx, 0xa2
            //   4c8d0d47450300       | dec                 esp
            //   b910000000           | lea                 ecx, [0x34547]
            //   448d42a0             | mov                 ecx, 0x10

        $sequence_2 = { 0fb6c2 418b8c8270c30400 81e100ff0000 4433c1 453341fc 453343fc }
            // n = 6, score = 400
            //   0fb6c2               | lea                 edx, [edx + 0x16]
            //   418b8c8270c30400     | test                eax, eax
            //   81e100ff0000         | jne                 0xe
            //   4433c1               | mov                 eax, 5
            //   453341fc             | movzx               eax, dl
            //   453343fc             | inc                 ecx

        $sequence_3 = { b801000000 418bc8 0f45c8 488d05c0150300 488d1d11aa0300 85c9 }
            // n = 6, score = 400
            //   b801000000           | mov                 ecx, dword ptr [edx + eax*4 + 0x4c370]
            //   418bc8               | and                 ecx, 0xff00
            //   0f45c8               | inc                 esp
            //   488d05c0150300       | xor                 eax, ecx
            //   488d1d11aa0300       | inc                 ebp
            //   85c9                 | xor                 eax, dword ptr [ecx - 4]

        $sequence_4 = { 4c8d0583520100 418d5216 e8???????? 85c0 750a b805000000 }
            // n = 6, score = 400
            //   4c8d0583520100       | inc                 esp
            //   418d5216             | lea                 eax, [edx - 0x60]
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   750a                 | lea                 eax, [0x15283]
            //   b805000000           | inc                 ecx

        $sequence_5 = { 6690 e8???????? 48ffc3 8bf8 b84fecc44e f7ef }
            // n = 6, score = 400
            //   6690                 | inc                 ebp
            //   e8????????           |                     
            //   48ffc3               | xor                 eax, dword ptr [ebx - 4]
            //   8bf8                 | mov                 eax, 1
            //   b84fecc44e           | inc                 ecx
            //   f7ef                 | mov                 ecx, eax

        $sequence_6 = { 89742440 48894598 c744245068000000 c744247004010000 }
            // n = 4, score = 400
            //   89742440             | nop                 
            //   48894598             | dec                 eax
            //   c744245068000000     | inc                 ebx
            //   c744247004010000     | mov                 edi, eax

        $sequence_7 = { 0fb6c8 8bc5 8b948e70cf0400 48c1e808 0fb6c8 81e20000ff00 }
            // n = 6, score = 400
            //   0fb6c8               | cmovne              ecx, eax
            //   8bc5                 | dec                 eax
            //   8b948e70cf0400       | lea                 eax, [0x315c0]
            //   48c1e808             | dec                 eax
            //   0fb6c8               | lea                 ebx, [0x3aa11]
            //   81e20000ff00         | test                ecx, ecx

        $sequence_8 = { e8???????? a1???????? 8b8da8f8ffff c1e00a d1e8 2bcf }
            // n = 6, score = 100
            //   e8????????           |                     
            //   a1????????           |                     
            //   8b8da8f8ffff         | mov                 ecx, dword ptr [ebp - 0x758]
            //   c1e00a               | shl                 eax, 0xa
            //   d1e8                 | shr                 eax, 1
            //   2bcf                 | sub                 ecx, edi

        $sequence_9 = { 33d2 8a54242a 8adc 8b149538600410 }
            // n = 4, score = 100
            //   33d2                 | xor                 edx, edx
            //   8a54242a             | mov                 dl, byte ptr [esp + 0x2a]
            //   8adc                 | mov                 bl, ah
            //   8b149538600410       | mov                 edx, dword ptr [edx*4 + 0x10046038]

        $sequence_10 = { 5b c3 8b74241c 8b6c2414 85f6 }
            // n = 5, score = 100
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]
            //   8b6c2414             | mov                 ebp, dword ptr [esp + 0x14]
            //   85f6                 | test                esi, esi

        $sequence_11 = { 6806020000 8d8d7ef7ffff 53 51 885de8 8945e9 }
            // n = 6, score = 100
            //   6806020000           | push                0x206
            //   8d8d7ef7ffff         | lea                 ecx, [ebp - 0x882]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   885de8               | mov                 byte ptr [ebp - 0x18], bl
            //   8945e9               | mov                 dword ptr [ebp - 0x17], eax

        $sequence_12 = { 52 ff15???????? a3???????? 85c0 7440 399de8e5ffff 750a }
            // n = 7, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   7440                 | je                  0x42
            //   399de8e5ffff         | cmp                 dword ptr [ebp - 0x1a18], ebx
            //   750a                 | jne                 0xc

        $sequence_13 = { 8b0c8d38500410 33d3 8b3cbd38500410 81e1ff000000 }
            // n = 4, score = 100
            //   8b0c8d38500410       | mov                 ecx, dword ptr [ecx*4 + 0x10045038]
            //   33d3                 | xor                 edx, ebx
            //   8b3cbd38500410       | mov                 edi, dword ptr [edi*4 + 0x10045038]
            //   81e1ff000000         | and                 ecx, 0xff

        $sequence_14 = { 74ab 8d8df4feffff 51 e8???????? 83c404 }
            // n = 5, score = 100
            //   74ab                 | je                  0xffffffad
            //   8d8df4feffff         | lea                 ecx, [ebp - 0x10c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

    condition:
        7 of them and filesize < 1429504
}