rule win_common_magic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.common_magic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.common_magic"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 59 5d c20400 e8???????? 85c0 0f84c02e0000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84c02e0000         | je                  0x2ec6

        $sequence_1 = { 885c012e 8b049570804100 804c012d04 46 }
            // n = 4, score = 100
            //   885c012e             | mov                 byte ptr [ecx + eax + 0x2e], bl
            //   8b049570804100       | mov                 eax, dword ptr [edx*4 + 0x418070]
            //   804c012d04           | or                  byte ptr [ecx + eax + 0x2d], 4
            //   46                   | inc                 esi

        $sequence_2 = { 8d8de8fdffff c685a4fdffff00 51 ffb5a4fdffff 8d8dacfdffff }
            // n = 5, score = 100
            //   8d8de8fdffff         | lea                 ecx, [ebp - 0x218]
            //   c685a4fdffff00       | mov                 byte ptr [ebp - 0x25c], 0
            //   51                   | push                ecx
            //   ffb5a4fdffff         | push                dword ptr [ebp - 0x25c]
            //   8d8dacfdffff         | lea                 ecx, [ebp - 0x254]

        $sequence_3 = { 68???????? 51 50 51 ffb580feffff 8d8d5cffffff e8???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   51                   | push                ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ffb580feffff         | push                dword ptr [ebp - 0x180]
            //   8d8d5cffffff         | lea                 ecx, [ebp - 0xa4]
            //   e8????????           |                     

        $sequence_4 = { 83c404 c645fc03 8b8d70ffffff 83f908 }
            // n = 4, score = 100
            //   83c404               | add                 esp, 4
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8b8d70ffffff         | mov                 ecx, dword ptr [ebp - 0x90]
            //   83f908               | cmp                 ecx, 8

        $sequence_5 = { 0f1f4000 0f1f840000000000 a1???????? c7855cffffff00000000 }
            // n = 4, score = 100
            //   0f1f4000             | nop                 dword ptr [eax]
            //   0f1f840000000000     | nop                 dword ptr [eax + eax]
            //   a1????????           |                     
            //   c7855cffffff00000000     | mov    dword ptr [ebp - 0xa4], 0

        $sequence_6 = { ff7610 50 8d45c8 50 ffd7 }
            // n = 5, score = 100
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   50                   | push                eax
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_7 = { 75e8 8b7dd4 8b55c4 8d4dd4 8b45e8 8bf2 }
            // n = 6, score = 100
            //   75e8                 | jne                 0xffffffea
            //   8b7dd4               | mov                 edi, dword ptr [ebp - 0x2c]
            //   8b55c4               | mov                 edx, dword ptr [ebp - 0x3c]
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8bf2                 | mov                 esi, edx

        $sequence_8 = { 85c0 0f84c02e0000 c3 833d????????ff 7503 33c0 c3 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f84c02e0000         | je                  0x2ec6
            //   c3                   | ret                 
            //   833d????????ff       |                     
            //   7503                 | jne                 5
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 

        $sequence_9 = { 90 668b0431 663b01 750a 83c102 83ea01 75ef }
            // n = 7, score = 100
            //   90                   | nop                 
            //   668b0431             | mov                 ax, word ptr [ecx + esi]
            //   663b01               | cmp                 ax, word ptr [ecx]
            //   750a                 | jne                 0xc
            //   83c102               | add                 ecx, 2
            //   83ea01               | sub                 edx, 1
            //   75ef                 | jne                 0xfffffff1

    condition:
        7 of them and filesize < 212992
}