rule win_computrace_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.computrace."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.computrace"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4628 8d5508 6a04 52 56 ffd0 }
            // n = 6, score = 200
            //   8b4628               | mov                 eax, dword ptr [esi + 0x28]
            //   8d5508               | lea                 edx, [ebp + 8]
            //   6a04                 | push                4
            //   52                   | push                edx
            //   56                   | push                esi
            //   ffd0                 | call                eax

        $sequence_1 = { 7469 c7466c01000000 834e70ff 804e5c04 ff15???????? }
            // n = 5, score = 200
            //   7469                 | je                  0x6b
            //   c7466c01000000       | mov                 dword ptr [esi + 0x6c], 1
            //   834e70ff             | or                  dword ptr [esi + 0x70], 0xffffffff
            //   804e5c04             | or                  byte ptr [esi + 0x5c], 4
            //   ff15????????         |                     

        $sequence_2 = { 2bc7 7417 48 740f 48 }
            // n = 5, score = 200
            //   2bc7                 | sub                 eax, edi
            //   7417                 | je                  0x19
            //   48                   | dec                 eax
            //   740f                 | je                  0x11
            //   48                   | dec                 eax

        $sequence_3 = { 8d442404 50 6a01 6a00 6a03 ff15???????? c20400 }
            // n = 7, score = 200
            //   8d442404             | lea                 eax, [esp + 4]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   ff15????????         |                     
            //   c20400               | ret                 4

        $sequence_4 = { 894c862c 8935???????? 5e 8bc3 5b }
            // n = 5, score = 200
            //   894c862c             | mov                 dword ptr [esi + eax*4 + 0x2c], ecx
            //   8935????????         |                     
            //   5e                   | pop                 esi
            //   8bc3                 | mov                 eax, ebx
            //   5b                   | pop                 ebx

        $sequence_5 = { 3b0f 7cd3 c60600 2b750c 8937 5f 5e }
            // n = 7, score = 200
            //   3b0f                 | cmp                 ecx, dword ptr [edi]
            //   7cd3                 | jl                  0xffffffd5
            //   c60600               | mov                 byte ptr [esi], 0
            //   2b750c               | sub                 esi, dword ptr [ebp + 0xc]
            //   8937                 | mov                 dword ptr [edi], esi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 8845f3 33ff 397d14 7e1a }
            // n = 4, score = 200
            //   8845f3               | mov                 byte ptr [ebp - 0xd], al
            //   33ff                 | xor                 edi, edi
            //   397d14               | cmp                 dword ptr [ebp + 0x14], edi
            //   7e1a                 | jle                 0x1c

        $sequence_7 = { 56 8b35???????? 57 8b7d08 8d85f8feffff 50 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   8b35????????         |                     
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax

        $sequence_8 = { 7305 6681f22110 fecd 75f2 }
            // n = 4, score = 200
            //   7305                 | jae                 7
            //   6681f22110           | xor                 dx, 0x1021
            //   fecd                 | dec                 ch
            //   75f2                 | jne                 0xfffffff4

        $sequence_9 = { ffb6401b0000 ff15???????? 8d86301b0000 50 8d45e4 50 }
            // n = 6, score = 200
            //   ffb6401b0000         | push                dword ptr [esi + 0x1b40]
            //   ff15????????         |                     
            //   8d86301b0000         | lea                 eax, [esi + 0x1b30]
            //   50                   | push                eax
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 73728
}